/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.restore.snapshot;

import io.atomix.cluster.MemberId;
import io.zeebe.distributedlog.restore.RestoreStrategy;
import io.zeebe.distributedlog.restore.log.LogReplicator;
import io.zeebe.distributedlog.restore.snapshot.RestoreSnapshotReplicator;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreInfo;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class SnapshotRestoreStrategy
implements RestoreStrategy {
    private final MemberId server;
    private final LogReplicator logReplicator;
    private final Logger logger;
    private final long backupPosition;
    private final SnapshotRestoreInfo snapshotRestoreInfo;
    private final long latestLocalPosition;
    private final RestoreSnapshotReplicator replicator;

    public SnapshotRestoreStrategy(LogReplicator logReplicator, RestoreSnapshotReplicator replicator, SnapshotRestoreInfo snapshotRestoreInfo, long latestLocalPosition, long backupPosition, MemberId server, Logger logger) {
        this.logReplicator = logReplicator;
        this.replicator = replicator;
        this.snapshotRestoreInfo = snapshotRestoreInfo;
        this.latestLocalPosition = latestLocalPosition;
        this.backupPosition = backupPosition;
        this.server = server;
        this.logger = logger;
    }

    @Override
    public CompletableFuture<Long> executeRestoreStrategy() {
        this.logger.debug("Restoring snapshot {} from server {} (expecting {} chunks)", new Object[]{this.snapshotRestoreInfo.getSnapshotId(), this.server, this.snapshotRestoreInfo.getNumChunks()});
        return this.replicator.restore(this.server, this.snapshotRestoreInfo.getSnapshotId(), this.snapshotRestoreInfo.getNumChunks()).thenCompose(tuple -> this.onSnapshotsReplicated((Long)tuple.getLeft(), (Long)tuple.getRight()));
    }

    private CompletableFuture<Long> onSnapshotsReplicated(long exporterPosition, long processedPosition) {
        long fromPosition = Math.max(this.latestLocalPosition, this.getFirstEventToBeReplicated(exporterPosition, processedPosition));
        long toPosition = Math.max(processedPosition, this.backupPosition);
        this.logger.debug("Restored snapshot {} from server {}; restoring events from {} to {}", new Object[]{this.snapshotRestoreInfo.getSnapshotId(), this.server, fromPosition, toPosition});
        return this.logReplicator.replicate(this.server, fromPosition, toPosition, fromPosition > this.latestLocalPosition);
    }

    private long getFirstEventToBeReplicated(long exporterPosition, long processedPosition) {
        return Math.min(processedPosition, exporterPosition);
    }
}

