/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.client.api.response.ActivatedJob;
import io.zeebe.client.impl.ZeebeObjectMapper;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Map;

public class ActivatedJobImpl
implements ActivatedJob {
    @JsonIgnore
    private final ZeebeObjectMapper objectMapper;
    private final long key;
    private final String type;
    private final Map<String, String> customHeaders;
    private final long workflowInstanceKey;
    private final String bpmnProcessId;
    private final int workflowDefinitionVersion;
    private final long workflowKey;
    private final String elementId;
    private final long elementInstanceKey;
    private final String worker;
    private final int retries;
    private final long deadline;
    private final String variables;

    public ActivatedJobImpl(ZeebeObjectMapper objectMapper, GatewayOuterClass.ActivatedJob job) {
        this.objectMapper = objectMapper;
        this.key = job.getKey();
        this.type = job.getType();
        this.customHeaders = objectMapper.fromJsonAsStringMap(job.getCustomHeaders());
        this.worker = job.getWorker();
        this.retries = job.getRetries();
        this.deadline = job.getDeadline();
        this.variables = job.getVariables();
        this.workflowInstanceKey = job.getWorkflowInstanceKey();
        this.bpmnProcessId = job.getBpmnProcessId();
        this.workflowDefinitionVersion = job.getWorkflowDefinitionVersion();
        this.workflowKey = job.getWorkflowKey();
        this.elementId = job.getElementId();
        this.elementInstanceKey = job.getElementInstanceKey();
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getWorkflowDefinitionVersion() {
        return this.workflowDefinitionVersion;
    }

    @Override
    public long getWorkflowKey() {
        return this.workflowKey;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    @Override
    public String getWorker() {
        return this.worker;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    public String getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, Object> getVariablesAsMap() {
        return this.objectMapper.fromJsonAsMap(this.variables);
    }

    @Override
    public <T> T getVariablesAsType(Class<T> variableType) {
        return this.objectMapper.fromJson(this.variables, variableType);
    }

    @Override
    public String toJson() {
        return this.objectMapper.toJson(this);
    }

    public String toString() {
        return this.toJson();
    }
}

