/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.command.TopologyRequestStep1;
import io.zeebe.client.api.response.Topology;
import io.zeebe.client.impl.ZeebeClientFutureImpl;
import io.zeebe.client.impl.response.TopologyImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class TopologyRequestImpl
implements TopologyRequestStep1 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private Duration requestTimeout;

    public TopologyRequestImpl(GatewayGrpc.GatewayStub asyncStub, Duration requestTimeout) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
    }

    @Override
    public FinalCommandStep<Topology> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<Topology> send() {
        GatewayOuterClass.TopologyRequest request = GatewayOuterClass.TopologyRequest.getDefaultInstance();
        ZeebeClientFutureImpl<Topology, GatewayOuterClass.TopologyResponse> future = new ZeebeClientFutureImpl<Topology, GatewayOuterClass.TopologyResponse>(TopologyImpl::new);
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).topology(request, future);
        return future;
    }
}

