/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.command.SetVariablesCommandStep1;
import io.zeebe.client.impl.ZeebeClientFutureImpl;
import io.zeebe.client.impl.ZeebeObjectMapper;
import io.zeebe.client.impl.command.ArgumentUtil;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SetVariablesCommandImpl
implements SetVariablesCommandStep1,
SetVariablesCommandStep1.SetVariablesCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.SetVariablesRequest.Builder builder;
    private final ZeebeObjectMapper objectMapper;
    private final long elementInstanceKey;
    private Duration requestTimeout;

    public SetVariablesCommandImpl(GatewayGrpc.GatewayStub asyncStub, ZeebeObjectMapper objectMapper, long elementInstanceKey, Duration requestTimeout) {
        this.asyncStub = asyncStub;
        this.objectMapper = objectMapper;
        this.elementInstanceKey = elementInstanceKey;
        this.requestTimeout = requestTimeout;
        this.builder = GatewayOuterClass.SetVariablesRequest.newBuilder();
        this.builder.setElementInstanceKey(elementInstanceKey);
    }

    @Override
    public FinalCommandStep<Void> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<Void> send() {
        GatewayOuterClass.SetVariablesRequest request = this.builder.build();
        ZeebeClientFutureImpl future = new ZeebeClientFutureImpl();
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).setVariables(request, future);
        return future;
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 local(boolean local) {
        this.builder.setLocal(local);
        return this;
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(InputStream variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.objectMapper.validateJson("variables", variables));
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(String variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.objectMapper.validateJson("variables", variables));
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(Map<String, Object> variables) {
        return this.variables((Object)variables);
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(Object variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.objectMapper.toJson(variables));
    }

    private SetVariablesCommandStep1.SetVariablesCommandStep2 setVariables(String jsonDocument) {
        this.builder.setVariables(jsonDocument);
        return this;
    }
}

