/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.zeebe.client.ZeebeClientConfiguration;
import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.command.PublishMessageCommandStep1;
import io.zeebe.client.impl.ZeebeClientFutureImpl;
import io.zeebe.client.impl.ZeebeObjectMapper;
import io.zeebe.client.impl.command.CommandWithVariables;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class PublishMessageCommandImpl
extends CommandWithVariables<PublishMessageCommandImpl>
implements PublishMessageCommandStep1,
PublishMessageCommandStep1.PublishMessageCommandStep2,
PublishMessageCommandStep1.PublishMessageCommandStep3 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.PublishMessageRequest.Builder builder;
    private Duration requestTimeout;

    public PublishMessageCommandImpl(GatewayGrpc.GatewayStub asyncStub, ZeebeClientConfiguration configuration, ZeebeObjectMapper objectMapper) {
        super(objectMapper);
        this.asyncStub = asyncStub;
        this.builder = GatewayOuterClass.PublishMessageRequest.newBuilder();
        this.requestTimeout = configuration.getDefaultRequestTimeout();
        this.builder.setTimeToLive(configuration.getDefaultMessageTimeToLive().toMillis());
    }

    @Override
    protected PublishMessageCommandImpl setVariablesInternal(String variables) {
        this.builder.setVariables(variables);
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep3 messageId(String messageId) {
        this.builder.setMessageId(messageId);
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep3 timeToLive(Duration timeToLive) {
        this.builder.setTimeToLive(timeToLive.toMillis());
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep3 correlationKey(String correlationKey) {
        this.builder.setCorrelationKey(correlationKey);
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep2 messageName(String messageName) {
        this.builder.setName(messageName);
        return this;
    }

    @Override
    public FinalCommandStep<Void> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<Void> send() {
        ZeebeClientFutureImpl future = new ZeebeClientFutureImpl();
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).publishMessage(this.builder.build(), future);
        return future;
    }
}

