/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.zeebe.client.ZeebeClientConfiguration;
import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.response.ActivateJobsResponse;
import io.zeebe.client.impl.ZeebeObjectMapper;
import io.zeebe.client.impl.ZeebeStreamingClientFutureImpl;
import io.zeebe.client.impl.response.ActivateJobsResponseImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ActivateJobsCommandImpl
implements ActivateJobsCommandStep1,
ActivateJobsCommandStep1.ActivateJobsCommandStep2,
ActivateJobsCommandStep1.ActivateJobsCommandStep3 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final ZeebeObjectMapper objectMapper;
    private final GatewayOuterClass.ActivateJobsRequest.Builder builder;
    private Duration requestTimeout;

    public ActivateJobsCommandImpl(GatewayGrpc.GatewayStub asyncStub, ZeebeClientConfiguration config, ZeebeObjectMapper objectMapper) {
        this.asyncStub = asyncStub;
        this.objectMapper = objectMapper;
        this.builder = GatewayOuterClass.ActivateJobsRequest.newBuilder();
        this.requestTimeout = config.getDefaultRequestTimeout();
        this.timeout(config.getDefaultJobTimeout());
        this.workerName(config.getDefaultJobWorkerName());
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep2 jobType(String jobType) {
        this.builder.setType(jobType);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 maxJobsToActivate(int maxJobsToActivate) {
        this.builder.setMaxJobsToActivate(maxJobsToActivate);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 timeout(long timeout) {
        this.builder.setTimeout(timeout);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 timeout(Duration timeout) {
        return this.timeout(timeout.toMillis());
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 workerName(String workerName) {
        this.builder.setWorker(workerName);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 fetchVariables(List<String> fetchVariables) {
        this.builder.addAllFetchVariable(fetchVariables);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 fetchVariables(String ... fetchVariables) {
        return this.fetchVariables(Arrays.asList(fetchVariables));
    }

    @Override
    public FinalCommandStep<ActivateJobsResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<ActivateJobsResponse> send() {
        GatewayOuterClass.ActivateJobsRequest request = this.builder.build();
        ActivateJobsResponseImpl response = new ActivateJobsResponseImpl(this.objectMapper);
        ZeebeStreamingClientFutureImpl<ActivateJobsResponseImpl, GatewayOuterClass.ActivateJobsResponse> future = new ZeebeStreamingClientFutureImpl<ActivateJobsResponseImpl, GatewayOuterClass.ActivateJobsResponse>(response, response::addResponse);
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).activateJobs(request, future);
        return future;
    }
}

