/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.grpc.Metadata;
import io.zeebe.client.CredentialsProvider;
import io.zeebe.client.impl.ZeebeClientAuthInfo;
import io.zeebe.client.impl.ZeebeClientCredentials;
import java.io.File;
import java.io.IOException;

public class ZeebeClientCredentialsProvider
implements CredentialsProvider {
    public static final String INVALID_PATH_ERROR_MSG = "Expected valid path to Zeebe credentials but '%s' is either invalid or does not point to a file.";
    private static final TypeReference<ZeebeClientAuthInfo> TYPE_REF = new TypeReference<ZeebeClientAuthInfo>(){};
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final Metadata.Key<String> HEADER_AUTH_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final String zeebeCredentialsPath;

    public ZeebeClientCredentialsProvider(String zeebeCredentialsPath) {
        if (!this.isValidCredentialsPath(zeebeCredentialsPath)) {
            throw new IllegalArgumentException(String.format(INVALID_PATH_ERROR_MSG, zeebeCredentialsPath));
        }
        this.zeebeCredentialsPath = zeebeCredentialsPath;
    }

    private boolean isValidCredentialsPath(String zeebeCredentialsPath) {
        if (zeebeCredentialsPath == null || zeebeCredentialsPath.isEmpty()) {
            return false;
        }
        File credentialsFile = new File(zeebeCredentialsPath);
        return credentialsFile.exists();
    }

    @Override
    public void applyCredentials(Metadata headers) {
        try {
            ZeebeClientCredentials credentials = this.getAccessCredentials();
            headers.put(HEADER_AUTH_KEY, (Object)String.format("%s %s", credentials.getTokenType().trim(), credentials.getAccessToken().trim()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ZeebeClientCredentials getAccessCredentials() throws IOException {
        JsonNode node = MAPPER.readTree(new File(this.zeebeCredentialsPath));
        node = node.get("endpoint").get("auth");
        ZeebeClientAuthInfo clientAuthInfo = (ZeebeClientAuthInfo)MAPPER.readValue(node.traverse(), TYPE_REF);
        return clientAuthInfo.getCredentials();
    }
}

