/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.SecurityLevel;
import io.zeebe.client.CredentialsProvider;
import io.zeebe.util.ZbLogger;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

public class ZeebeCallCredentials
extends CallCredentials {
    private static final Logger LOG = new ZbLogger(ZeebeCallCredentials.class);
    private final CredentialsProvider credentialsProvider;

    ZeebeCallCredentials(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        if (requestInfo.getSecurityLevel().ordinal() < SecurityLevel.PRIVACY_AND_INTEGRITY.ordinal()) {
            LOG.warn("The request's security level does not guarantee that the credentials will be confidential.");
        }
        Metadata headers = new Metadata();
        this.credentialsProvider.applyCredentials(headers);
        applier.apply(headers);
    }

    public void thisUsesUnstableApi() {
    }
}

