/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.Preconditions;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.FileBuffer;
import io.atomix.storage.buffer.HeapBuffer;

public final class SnapshotDescriptor
implements AutoCloseable {
    public static final int BYTES = 64;
    private static final int VERSION = 1;
    private static final int INDEX_LENGTH = 8;
    private static final int TIMESTAMP_LENGTH = 8;
    private static final int VERSION_LENGTH = 4;
    private static final int LOCKED_LENGTH = 1;
    private static final int TERM_LENGTH = 8;
    private static final int INDEX_POSITION = 0;
    private static final int TIMESTAMP_POSITION = 8;
    private static final int VERSION_POSITION = 16;
    private static final int LOCKED_POSITION = 20;
    private static final int TERM_POSITION = 21;
    private Buffer buffer;
    private final long index;
    private final long timestamp;
    private final long term;
    private boolean locked;
    private int version;

    public static Builder builder() {
        return new Builder((Buffer)HeapBuffer.allocate((int)64));
    }

    public static Builder builder(Buffer buffer) {
        return new Builder(buffer);
    }

    public SnapshotDescriptor(Buffer buffer) {
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer cannot be null");
        this.index = buffer.readLong();
        this.timestamp = buffer.readLong();
        this.version = buffer.readInt();
        this.locked = buffer.readBoolean();
        this.term = buffer.readLong();
        buffer.skip(64 - buffer.position());
    }

    public long index() {
        return this.index;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public int version() {
        return this.version;
    }

    public long term() {
        return this.term;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() {
        ((Buffer)this.buffer.flush()).writeBoolean(20, true).flush();
        this.locked = true;
    }

    SnapshotDescriptor copyTo(Buffer buffer) {
        this.buffer = (Buffer)buffer.writeLong(this.index).writeLong(this.timestamp).writeInt(this.version).writeBoolean(this.locked).writeLong(this.term).skip(64 - buffer.position()).flush();
        return this;
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public void delete() {
        if (this.buffer instanceof FileBuffer) {
            ((FileBuffer)this.buffer).delete();
        }
    }

    public static class Builder {
        private final Buffer buffer;

        private Builder(Buffer buffer) {
            this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer cannot be null");
        }

        public Builder withIndex(long index) {
            this.buffer.writeLong(0, index);
            return this;
        }

        public Builder withTerm(long term) {
            this.buffer.writeLong(21, term);
            return this;
        }

        public Builder withTimestamp(long timestamp) {
            this.buffer.writeLong(8, timestamp);
            return this;
        }

        public SnapshotDescriptor build() {
            return new SnapshotDescriptor(this.buffer.writeInt(16, 1));
        }
    }
}

