/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.storage.snapshot.SnapshotDescriptor;
import io.atomix.protocols.raft.storage.snapshot.SnapshotReader;
import io.atomix.protocols.raft.storage.snapshot.SnapshotStore;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.utils.time.WallClockTimestamp;
import java.util.Objects;

public abstract class Snapshot
implements AutoCloseable {
    protected final SnapshotDescriptor descriptor;
    protected final SnapshotStore store;
    private SnapshotWriter writer;

    protected Snapshot(SnapshotDescriptor descriptor, SnapshotStore store) {
        this.descriptor = (SnapshotDescriptor)Preconditions.checkNotNull((Object)descriptor, (Object)"descriptor cannot be null");
        this.store = (SnapshotStore)Preconditions.checkNotNull((Object)store, (Object)"store cannot be null");
    }

    public long index() {
        return this.descriptor.index();
    }

    public long term() {
        return this.descriptor.term();
    }

    public WallClockTimestamp timestamp() {
        return WallClockTimestamp.from((long)this.descriptor.timestamp());
    }

    public int version() {
        return this.descriptor.version();
    }

    public abstract SnapshotWriter openWriter();

    protected void checkWriter() {
        Preconditions.checkState((this.writer == null ? 1 : 0) != 0, (Object)"cannot create multiple writers for the same snapshot");
    }

    protected SnapshotWriter openWriter(SnapshotWriter writer, SnapshotDescriptor descriptor) {
        this.checkWriter();
        Preconditions.checkState((!descriptor.isLocked() ? 1 : 0) != 0, (Object)"cannot write to locked snapshot descriptor");
        this.writer = (SnapshotWriter)Preconditions.checkNotNull((Object)writer, (Object)"writer cannot be null");
        return writer;
    }

    protected void closeWriter(SnapshotWriter writer) {
        this.writer = null;
    }

    public abstract SnapshotReader openReader();

    protected SnapshotReader openReader(SnapshotReader reader, SnapshotDescriptor descriptor) {
        Preconditions.checkState((boolean)descriptor.isLocked(), (Object)"cannot read from unlocked snapshot descriptor");
        return reader;
    }

    protected void closeReader(SnapshotReader reader) {
    }

    public Snapshot complete() {
        this.store.completeSnapshot(this);
        return this;
    }

    @Override
    public void close() {
    }

    public void delete() {
    }

    public int hashCode() {
        return Objects.hash(this.index());
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Snapshot snapshot = (Snapshot)object;
        return snapshot.index() == this.index() && snapshot.term() == this.term();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index()).add("term", this.term()).toString();
    }
}

