/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotDescriptor;
import io.atomix.protocols.raft.storage.snapshot.SnapshotReader;
import io.atomix.protocols.raft.storage.snapshot.SnapshotStore;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.storage.buffer.HeapBuffer;

final class MemorySnapshot
extends Snapshot {
    private final HeapBuffer buffer;
    private final SnapshotDescriptor descriptor;

    MemorySnapshot(HeapBuffer buffer, SnapshotDescriptor descriptor, SnapshotStore store) {
        super(descriptor, store);
        buffer.mark();
        this.buffer = (HeapBuffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer cannot be null");
        this.buffer.position(64).mark();
        this.descriptor = (SnapshotDescriptor)Preconditions.checkNotNull((Object)descriptor, (Object)"descriptor cannot be null");
    }

    @Override
    public SnapshotWriter openWriter() {
        this.checkWriter();
        return new SnapshotWriter(this.buffer.reset().slice(), this);
    }

    @Override
    protected void closeWriter(SnapshotWriter writer) {
        this.buffer.skip(writer.buffer.position()).mark();
        super.closeWriter(writer);
    }

    @Override
    public synchronized SnapshotReader openReader() {
        return this.openReader(new SnapshotReader(this.buffer.reset().slice(), this), this.descriptor);
    }

    @Override
    public Snapshot complete() {
        this.buffer.flip().skip(64).mark();
        this.descriptor.lock();
        return super.complete();
    }

    @Override
    public void close() {
        this.buffer.close();
    }
}

