/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import java.util.Objects;

public abstract class SessionRequest
extends AbstractRaftRequest {
    protected final long session;

    protected SessionRequest(long session) {
        this.session = session;
    }

    public long session() {
        return this.session;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.session);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().isAssignableFrom(object.getClass())) {
            return false;
        }
        SessionRequest request = (SessionRequest)object;
        return request.session == this.session;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", this.session).toString();
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends SessionRequest>
    extends AbstractRaftRequest.Builder<T, U> {
        protected long session;

        public T withSession(long session) {
            Preconditions.checkArgument((session > 0L ? 1 : 0) != 0, (Object)"session must be positive");
            this.session = session;
            return (T)this;
        }

        @Override
        protected void validate() {
            Preconditions.checkArgument((this.session > 0L ? 1 : 0) != 0, (Object)"session must be positive");
        }
    }
}

