/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.spring.client.properties;

import io.zeebe.spring.client.config.ZeebeClientSpringConfiguration;
import io.zeebe.spring.client.properties.ZeebeClientProperties;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="zeebe.client")
public class ZeebeClientConfigurationProperties
implements ZeebeClientProperties {
    @NestedConfigurationProperty
    private Broker broker = new Broker();
    @NestedConfigurationProperty
    private Worker worker = new Worker();
    @NestedConfigurationProperty
    private Message message = new Message();

    public String getBrokerContactPoint() {
        return this.broker.getContactPoint();
    }

    public Duration getDefaultRequestTimeout() {
        return this.broker.getRequestTimeout();
    }

    public int getNumJobWorkerExecutionThreads() {
        return this.worker.getThreads();
    }

    public int getDefaultJobWorkerMaxJobsActive() {
        return this.worker.getMaxJobsActive();
    }

    public String getDefaultJobWorkerName() {
        return this.worker.getName();
    }

    public Duration getDefaultJobTimeout() {
        return this.worker.getTimeout();
    }

    public Duration getDefaultJobPollInterval() {
        return this.worker.getPollInterval();
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.message.getTimeToLive();
    }

    public Broker getBroker() {
        return this.broker;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZeebeClientConfigurationProperties)) {
            return false;
        }
        ZeebeClientConfigurationProperties other = (ZeebeClientConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Broker this$broker = this.getBroker();
        Broker other$broker = other.getBroker();
        if (this$broker == null ? other$broker != null : !((Object)this$broker).equals(other$broker)) {
            return false;
        }
        Worker this$worker = this.getWorker();
        Worker other$worker = other.getWorker();
        if (this$worker == null ? other$worker != null : !((Object)this$worker).equals(other$worker)) {
            return false;
        }
        Message this$message = this.getMessage();
        Message other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZeebeClientConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Broker $broker = this.getBroker();
        result = result * 59 + ($broker == null ? 43 : ((Object)$broker).hashCode());
        Worker $worker = this.getWorker();
        result = result * 59 + ($worker == null ? 43 : ((Object)$worker).hashCode());
        Message $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        return result;
    }

    public String toString() {
        return "ZeebeClientConfigurationProperties(broker=" + this.getBroker() + ", worker=" + this.getWorker() + ", message=" + this.getMessage() + ")";
    }

    public static class Message {
        private Duration timeToLive = ZeebeClientSpringConfiguration.DEFAULT.getDefaultMessageTimeToLive();

        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Duration this$timeToLive = this.getTimeToLive();
            Duration other$timeToLive = other.getTimeToLive();
            return !(this$timeToLive == null ? other$timeToLive != null : !((Object)this$timeToLive).equals(other$timeToLive));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $timeToLive = this.getTimeToLive();
            result = result * 59 + ($timeToLive == null ? 43 : ((Object)$timeToLive).hashCode());
            return result;
        }

        public String toString() {
            return "ZeebeClientConfigurationProperties.Message(timeToLive=" + this.getTimeToLive() + ")";
        }
    }

    public static class Worker {
        private String name = ZeebeClientSpringConfiguration.DEFAULT.getDefaultJobWorkerName();
        private Duration timeout = ZeebeClientSpringConfiguration.DEFAULT.getDefaultJobTimeout();
        private Integer maxJobsActive = ZeebeClientSpringConfiguration.DEFAULT.getDefaultJobWorkerMaxJobsActive();
        private Duration pollInterval = ZeebeClientSpringConfiguration.DEFAULT.getDefaultJobPollInterval();
        private Integer threads = ZeebeClientSpringConfiguration.DEFAULT.getNumJobWorkerExecutionThreads();

        public String getName() {
            return this.name;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Integer getMaxJobsActive() {
            return this.maxJobsActive;
        }

        public Duration getPollInterval() {
            return this.pollInterval;
        }

        public Integer getThreads() {
            return this.threads;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public void setMaxJobsActive(Integer maxJobsActive) {
            this.maxJobsActive = maxJobsActive;
        }

        public void setPollInterval(Duration pollInterval) {
            this.pollInterval = pollInterval;
        }

        public void setThreads(Integer threads) {
            this.threads = threads;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Worker)) {
                return false;
            }
            Worker other = (Worker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Duration this$timeout = this.getTimeout();
            Duration other$timeout = other.getTimeout();
            if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
                return false;
            }
            Integer this$maxJobsActive = this.getMaxJobsActive();
            Integer other$maxJobsActive = other.getMaxJobsActive();
            if (this$maxJobsActive == null ? other$maxJobsActive != null : !((Object)this$maxJobsActive).equals(other$maxJobsActive)) {
                return false;
            }
            Duration this$pollInterval = this.getPollInterval();
            Duration other$pollInterval = other.getPollInterval();
            if (this$pollInterval == null ? other$pollInterval != null : !((Object)this$pollInterval).equals(other$pollInterval)) {
                return false;
            }
            Integer this$threads = this.getThreads();
            Integer other$threads = other.getThreads();
            return !(this$threads == null ? other$threads != null : !((Object)this$threads).equals(other$threads));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Worker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Duration $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            Integer $maxJobsActive = this.getMaxJobsActive();
            result = result * 59 + ($maxJobsActive == null ? 43 : ((Object)$maxJobsActive).hashCode());
            Duration $pollInterval = this.getPollInterval();
            result = result * 59 + ($pollInterval == null ? 43 : ((Object)$pollInterval).hashCode());
            Integer $threads = this.getThreads();
            result = result * 59 + ($threads == null ? 43 : ((Object)$threads).hashCode());
            return result;
        }

        public String toString() {
            return "ZeebeClientConfigurationProperties.Worker(name=" + this.getName() + ", timeout=" + this.getTimeout() + ", maxJobsActive=" + this.getMaxJobsActive() + ", pollInterval=" + this.getPollInterval() + ", threads=" + this.getThreads() + ")";
        }
    }

    public static class Broker {
        private String contactPoint = ZeebeClientSpringConfiguration.DEFAULT.getBrokerContactPoint();
        private Duration requestTimeout = ZeebeClientSpringConfiguration.DEFAULT.getDefaultRequestTimeout();

        public String getContactPoint() {
            return this.contactPoint;
        }

        public Duration getRequestTimeout() {
            return this.requestTimeout;
        }

        public void setContactPoint(String contactPoint) {
            this.contactPoint = contactPoint;
        }

        public void setRequestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Broker)) {
                return false;
            }
            Broker other = (Broker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$contactPoint = this.getContactPoint();
            String other$contactPoint = other.getContactPoint();
            if (this$contactPoint == null ? other$contactPoint != null : !this$contactPoint.equals(other$contactPoint)) {
                return false;
            }
            Duration this$requestTimeout = this.getRequestTimeout();
            Duration other$requestTimeout = other.getRequestTimeout();
            return !(this$requestTimeout == null ? other$requestTimeout != null : !((Object)this$requestTimeout).equals(other$requestTimeout));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Broker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $contactPoint = this.getContactPoint();
            result = result * 59 + ($contactPoint == null ? 43 : $contactPoint.hashCode());
            Duration $requestTimeout = this.getRequestTimeout();
            result = result * 59 + ($requestTimeout == null ? 43 : ((Object)$requestTimeout).hashCode());
            return result;
        }

        public String toString() {
            return "ZeebeClientConfigurationProperties.Broker(contactPoint=" + this.getContactPoint() + ", requestTimeout=" + this.getRequestTimeout() + ")";
        }
    }
}

