/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.spring.client.config.processor;

import io.zeebe.client.ZeebeClient;
import io.zeebe.spring.client.annotation.ZeebeWorker;
import io.zeebe.spring.client.bean.ClassInfo;
import io.zeebe.spring.client.bean.value.factory.ReadZeebeWorkerValue;
import io.zeebe.spring.client.config.processor.BeanInfoPostProcessor;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ZeebeWorkerPostProcessor
extends BeanInfoPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ZeebeWorkerPostProcessor.class);
    private final ReadZeebeWorkerValue reader;

    @Override
    public boolean test(ClassInfo beanInfo) {
        return beanInfo.hasMethodAnnotation(ZeebeWorker.class);
    }

    @Override
    public Consumer<ZeebeClient> apply(ClassInfo beanInfo) {
        log.info("zeebeWorker: {}", (Object)beanInfo);
        ArrayList annotatedMethods = new ArrayList();
        ReflectionUtils.doWithMethods(beanInfo.getTargetClass(), method -> this.reader.apply(beanInfo.toMethodInfo(method)).ifPresent(annotatedMethods::add), (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        return client -> annotatedMethods.forEach(m -> {
            client.newWorker().jobType(m.getType()).handler((jobClient, job) -> m.getBeanInfo().invoke(jobClient, job)).name(m.getName()).maxJobsActive(m.getMaxJobsActive()).timeout(m.getTimeout()).open();
            log.info("register job worker: {}", m);
        });
    }

    public ZeebeWorkerPostProcessor(ReadZeebeWorkerValue reader) {
        this.reader = reader;
    }
}

