/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.spring.client.config.processor;

import io.zeebe.client.ZeebeClient;
import io.zeebe.client.api.response.DeploymentEvent;
import io.zeebe.spring.client.annotation.ZeebeDeployment;
import io.zeebe.spring.client.bean.ClassInfo;
import io.zeebe.spring.client.bean.value.ZeebeDeploymentValue;
import io.zeebe.spring.client.bean.value.factory.ReadZeebeDeploymentValue;
import io.zeebe.spring.client.config.processor.BeanInfoPostProcessor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentPostProcessor
extends BeanInfoPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DeploymentPostProcessor.class);
    private final ReadZeebeDeploymentValue reader;

    @Override
    public boolean test(ClassInfo beanInfo) {
        return beanInfo.hasClassAnnotation(ZeebeDeployment.class);
    }

    @Override
    public Consumer<ZeebeClient> apply(ClassInfo beanInfo) {
        ZeebeDeploymentValue value = (ZeebeDeploymentValue)this.reader.applyOrThrow(beanInfo);
        log.info("deployment: {}", (Object)value);
        return client -> {
            DeploymentEvent deploymentResult = (DeploymentEvent)client.newDeployCommand().addResourceFromClasspath(value.getClassPathResource()).send().join();
            log.info("Deployed: {}", (Object)deploymentResult.getWorkflows().stream().map(wf -> String.format("<%s:%d>", wf.getBpmnProcessId(), wf.getVersion())).collect(Collectors.joining(",")));
        };
    }

    public DeploymentPostProcessor(ReadZeebeDeploymentValue reader) {
        this.reader = reader;
    }
}

