/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.spring.client.bean;

import io.zeebe.spring.client.bean.BeanInfo;
import io.zeebe.spring.client.bean.ClassInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;

public final class MethodInfo
implements BeanInfo {
    private final ClassInfo classInfo;
    private final Method method;

    @Override
    public Object getBean() {
        return this.classInfo.getBean();
    }

    @Override
    public String getBeanName() {
        return this.classInfo.getBeanName();
    }

    public Object invoke(Object ... args) {
        try {
            return this.method.invoke(this.getBean(), args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new RuntimeException("Failed to invoke method: " + this.method.getName(), targetException);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to invoke method: " + this.method.getName(), e);
        }
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> type) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation((Method)this.method, type));
    }

    MethodInfo(ClassInfo classInfo, Method method) {
        this.classInfo = classInfo;
        this.method = method;
    }

    public static MethodInfoBuilder builder() {
        return new MethodInfoBuilder();
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodInfo)) {
            return false;
        }
        MethodInfo other = (MethodInfo)o;
        ClassInfo this$classInfo = this.getClassInfo();
        ClassInfo other$classInfo = other.getClassInfo();
        if (this$classInfo == null ? other$classInfo != null : !((Object)this$classInfo).equals(other$classInfo)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClassInfo $classInfo = this.getClassInfo();
        result = result * 59 + ($classInfo == null ? 43 : ((Object)$classInfo).hashCode());
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        return result;
    }

    public String toString() {
        return "MethodInfo(classInfo=" + this.getClassInfo() + ", method=" + this.getMethod() + ")";
    }

    public static class MethodInfoBuilder {
        private ClassInfo classInfo;
        private Method method;

        MethodInfoBuilder() {
        }

        public MethodInfoBuilder classInfo(ClassInfo classInfo) {
            this.classInfo = classInfo;
            return this;
        }

        public MethodInfoBuilder method(Method method) {
            this.method = method;
            return this;
        }

        public MethodInfo build() {
            return new MethodInfo(this.classInfo, this.method);
        }

        public String toString() {
            return "MethodInfo.MethodInfoBuilder(classInfo=" + this.classInfo + ", method=" + this.method + ")";
        }
    }
}

