/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.spring.client.bean;

import io.zeebe.spring.client.bean.BeanInfo;
import io.zeebe.spring.client.bean.MethodInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;

public final class ClassInfo
implements BeanInfo {
    private final Object bean;
    private final String beanName;

    public MethodInfo toMethodInfo(Method method) {
        return MethodInfo.builder().classInfo(this).method(method).build();
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> type) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation(this.getTargetClass(), type));
    }

    ClassInfo(Object bean, String beanName) {
        this.bean = bean;
        this.beanName = beanName;
    }

    public static ClassInfoBuilder builder() {
        return new ClassInfoBuilder();
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassInfo)) {
            return false;
        }
        ClassInfo other = (ClassInfo)o;
        Object this$bean = this.getBean();
        Object other$bean = other.getBean();
        if (this$bean == null ? other$bean != null : !this$bean.equals(other$bean)) {
            return false;
        }
        String this$beanName = this.getBeanName();
        String other$beanName = other.getBeanName();
        return !(this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $bean = this.getBean();
        result = result * 59 + ($bean == null ? 43 : $bean.hashCode());
        String $beanName = this.getBeanName();
        result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
        return result;
    }

    public String toString() {
        return "ClassInfo(bean=" + this.getBean() + ", beanName=" + this.getBeanName() + ")";
    }

    public static class ClassInfoBuilder {
        private Object bean;
        private String beanName;

        ClassInfoBuilder() {
        }

        public ClassInfoBuilder bean(Object bean) {
            this.bean = bean;
            return this;
        }

        public ClassInfoBuilder beanName(String beanName) {
            this.beanName = beanName;
            return this;
        }

        public ClassInfo build() {
            return new ClassInfo(this.bean, this.beanName);
        }

        public String toString() {
            return "ClassInfo.ClassInfoBuilder(bean=" + this.bean + ", beanName=" + this.beanName + ")";
        }
    }
}

