/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.spring.client;

import io.zeebe.client.ZeebeClient;
import io.zeebe.client.ZeebeClientConfiguration;
import io.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.zeebe.client.api.command.CancelWorkflowInstanceCommandStep1;
import io.zeebe.client.api.command.CompleteJobCommandStep1;
import io.zeebe.client.api.command.CreateWorkflowInstanceCommandStep1;
import io.zeebe.client.api.command.DeployWorkflowCommandStep1;
import io.zeebe.client.api.command.FailJobCommandStep1;
import io.zeebe.client.api.command.PublishMessageCommandStep1;
import io.zeebe.client.api.command.ResolveIncidentCommandStep1;
import io.zeebe.client.api.command.SetVariablesCommandStep1;
import io.zeebe.client.api.command.TopologyRequestStep1;
import io.zeebe.client.api.command.UpdateRetriesJobCommandStep1;
import io.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.zeebe.client.impl.ZeebeClientImpl;
import io.zeebe.spring.client.ZeebeClientObjectFactory;
import io.zeebe.spring.client.event.ClientStartedEvent;
import io.zeebe.spring.util.ZeebeAutoStartUpLifecycle;
import io.zeebe.spring.util.ZeebeObjectFactory;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.context.ApplicationEventPublisher;

public class ZeebeClientLifecycle
extends ZeebeAutoStartUpLifecycle<ZeebeClientImpl>
implements ZeebeClient {
    public static final int PHASE = 22222;
    private final ApplicationEventPublisher publisher;
    private final Set<Consumer<ZeebeClient>> startListener = new LinkedHashSet<Consumer<ZeebeClient>>();

    public ZeebeClientLifecycle(ZeebeClientObjectFactory factory, ApplicationEventPublisher publisher) {
        super(22222, (ZeebeObjectFactory)factory);
        this.publisher = publisher;
    }

    public ZeebeClientLifecycle addStartListener(Consumer<ZeebeClient> consumer) {
        this.startListener.add(consumer);
        return this;
    }

    public void start() {
        super.start();
        this.publisher.publishEvent((Object)new ClientStartedEvent());
        this.startListener.forEach(c -> c.accept(this));
    }

    public ZeebeClientConfiguration getConfiguration() {
        return ((ZeebeClientImpl)this.get()).getConfiguration();
    }

    public void close() {
        this.stop();
    }

    public TopologyRequestStep1 newTopologyRequest() {
        return ((ZeebeClientImpl)this.get()).newTopologyRequest();
    }

    public DeployWorkflowCommandStep1 newDeployCommand() {
        return ((ZeebeClientImpl)this.get()).newDeployCommand();
    }

    public CreateWorkflowInstanceCommandStep1 newCreateInstanceCommand() {
        return ((ZeebeClientImpl)this.get()).newCreateInstanceCommand();
    }

    public CancelWorkflowInstanceCommandStep1 newCancelInstanceCommand(long workflowInstanceKey) {
        return ((ZeebeClientImpl)this.get()).newCancelInstanceCommand(workflowInstanceKey);
    }

    public SetVariablesCommandStep1 newSetVariablesCommand(long elementInstanceKey) {
        return ((ZeebeClientImpl)this.get()).newSetVariablesCommand(elementInstanceKey);
    }

    public PublishMessageCommandStep1 newPublishMessageCommand() {
        return ((ZeebeClientImpl)this.get()).newPublishMessageCommand();
    }

    public ResolveIncidentCommandStep1 newResolveIncidentCommand(long incidentKey) {
        return ((ZeebeClientImpl)this.get()).newResolveIncidentCommand(incidentKey);
    }

    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(long jobKey) {
        return ((ZeebeClientImpl)this.get()).newUpdateRetriesCommand(jobKey);
    }

    public JobWorkerBuilderStep1 newWorker() {
        return ((ZeebeClientImpl)this.get()).newWorker();
    }

    public ActivateJobsCommandStep1 newActivateJobsCommand() {
        return ((ZeebeClientImpl)this.get()).newActivateJobsCommand();
    }

    public CompleteJobCommandStep1 newCompleteCommand(long jobKey) {
        return ((ZeebeClientImpl)this.get()).newCompleteCommand(jobKey);
    }

    public FailJobCommandStep1 newFailCommand(long jobKey) {
        return ((ZeebeClientImpl)this.get()).newFailCommand(jobKey);
    }
}

