/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.report.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.report.Reporter;
import io.vertx.ext.unit.report.TestResult;
import io.vertx.ext.unit.report.impl.ReportStream;
import java.util.function.Function;

public class SimpleFormatter
implements Reporter<ReportImpl> {
    private final String sep = System.lineSeparator();
    private final Function<String, ReportStream> streamFactory;

    public SimpleFormatter(Function<String, ReportStream> streamFactory) {
        this.streamFactory = streamFactory;
    }

    @Override
    public ReportImpl reportBeginTestSuite(String name) {
        ReportImpl report = new ReportImpl(this.streamFactory.apply(name), name);
        report.stream.info(Buffer.buffer((String)("Begin test suite " + name + this.sep)));
        return report;
    }

    @Override
    public void reportBeginTestCase(ReportImpl report, String name) {
        report.stream.info(Buffer.buffer((String)("Begin test " + name + this.sep)));
        report.run++;
    }

    @Override
    public void reportEndTestCase(ReportImpl report, String name, TestResult result) {
        if (result.succeeded()) {
            report.stream.info(Buffer.buffer((String)("Passed " + result.name() + this.sep)));
        } else {
            if (result.failure().isError()) {
                report.errors++;
            } else {
                report.failures++;
            }
            report.stream.error(Buffer.buffer((String)("Failed " + result.name() + this.sep)), result.failure().cause());
        }
    }

    @Override
    public void reportError(ReportImpl report, Throwable err) {
        report.stream.error(Buffer.buffer((String)("Test suite " + report.name + " failure" + this.sep)), err);
    }

    @Override
    public void reportEndTestSuite(ReportImpl report) {
        String msg = "End test suite " + report.name + " , run: " + report.run + ", Failures: " + report.failures + ", Errors: " + report.errors + this.sep;
        report.stream.info(Buffer.buffer((String)msg));
        report.stream.end();
    }

    public static class ReportImpl {
        private final ReportStream stream;
        private final String name;
        private int run;
        private int failures;
        private int errors;

        public ReportImpl(ReportStream stream, String name) {
            this.stream = stream;
            this.name = name;
        }
    }
}

