/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;

public class PipeImpl<T>
implements Pipe<T> {
    private static final Handler<AsyncResult<Void>> NULL_HANDLER = ar -> {};
    private final Future<Void> result;
    private final ReadStream<T> src;
    private boolean endOnSuccess = true;
    private boolean endOnFailure = true;
    private WriteStream<T> dst;

    public PipeImpl(ReadStream<T> src) {
        this.src = src;
        this.result = Future.future();
        src.endHandler(this.result::tryComplete);
        src.exceptionHandler(this.result::tryFail);
    }

    @Override
    public synchronized Pipe<T> endOnFailure(boolean end) {
        this.endOnFailure = end;
        return this;
    }

    @Override
    public synchronized Pipe<T> endOnSuccess(boolean end) {
        this.endOnSuccess = end;
        return this;
    }

    @Override
    public synchronized Pipe<T> endOnComplete(boolean end) {
        this.endOnSuccess = end;
        this.endOnFailure = end;
        return this;
    }

    @Override
    public void to(WriteStream<T> ws) {
        this.to(ws, NULL_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void to(WriteStream<T> ws, Handler<AsyncResult<Void>> completionHandler) {
        boolean endOnFailure;
        boolean endOnSuccess;
        if (ws == null) {
            throw new NullPointerException();
        }
        PipeImpl pipeImpl = this;
        synchronized (pipeImpl) {
            if (this.dst != null) {
                throw new IllegalStateException();
            }
            this.dst = ws;
            endOnSuccess = this.endOnSuccess;
            endOnFailure = this.endOnFailure;
        }
        Handler<Void> drainHandler = v -> this.src.resume();
        this.src.handler(item -> {
            ws.write(item);
            if (ws.writeQueueFull()) {
                this.src.pause();
                ws.drainHandler(drainHandler);
            }
        });
        ws.exceptionHandler(err -> this.result.tryFail(new WriteException((Throwable)err)));
        this.src.resume();
        this.result.setHandler(ar -> {
            try {
                this.src.handler(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.src.exceptionHandler((Handler)null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.src.endHandler(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ar.succeeded()) {
                    if (endOnSuccess) {
                        ws.end();
                    }
                } else {
                    Throwable err = ar.cause();
                    if (err instanceof WriteException) {
                        ar = Future.failedFuture(err.getCause());
                        this.src.resume();
                    } else if (endOnFailure) {
                        ws.end();
                    }
                }
            }
            catch (Exception e) {
                if (endOnFailure) {
                    ws.end();
                }
                completionHandler.handle(Future.failedFuture(e));
                return;
            }
            completionHandler.handle((AsyncResult<Void>)ar);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PipeImpl pipeImpl = this;
        synchronized (pipeImpl) {
            this.src.exceptionHandler((Handler)null);
            this.src.handler(null);
            if (this.dst != null) {
                this.dst.drainHandler(null);
                this.dst.exceptionHandler((Handler)null);
            }
            if (this.result.isComplete()) {
                return;
            }
        }
        this.src.resume();
    }

    private static class WriteException
    extends VertxException {
        private WriteException(Throwable cause) {
            super(cause, true);
        }
    }
}

