/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.netty.buffer.ByteBuf;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.impl.Arguments;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.streams.impl.InboundBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncFileImpl
implements AsyncFile {
    private static final Logger log = LoggerFactory.getLogger(AsyncFile.class);
    public static final int DEFAULT_READ_BUFFER_SIZE = 8192;
    private final VertxInternal vertx;
    private final AsynchronousFileChannel ch;
    private final ContextInternal context;
    private boolean closed;
    private Runnable closedDeferred;
    private long writesOutstanding;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> drainHandler;
    private long writePos;
    private int maxWrites = 131072;
    private int lwm = this.maxWrites / 2;
    private int readBufferSize = 8192;
    private InboundBuffer<Buffer> queue;
    private Handler<Buffer> handler;
    private Handler<Void> endHandler;
    private long readPos;

    AsyncFileImpl(VertxInternal vertx, String path, OpenOptions options, ContextInternal context) {
        if (!options.isRead() && !options.isWrite()) {
            throw new FileSystemException("Cannot open file for neither reading nor writing");
        }
        this.vertx = vertx;
        Path file = Paths.get(path, new String[0]);
        HashSet<StandardOpenOption> opts = new HashSet<StandardOpenOption>();
        if (options.isRead()) {
            opts.add(StandardOpenOption.READ);
        }
        if (options.isWrite()) {
            opts.add(StandardOpenOption.WRITE);
        }
        if (options.isCreate()) {
            opts.add(StandardOpenOption.CREATE);
        }
        if (options.isCreateNew()) {
            opts.add(StandardOpenOption.CREATE_NEW);
        }
        if (options.isSync()) {
            opts.add(StandardOpenOption.SYNC);
        }
        if (options.isDsync()) {
            opts.add(StandardOpenOption.DSYNC);
        }
        if (options.isDeleteOnClose()) {
            opts.add(StandardOpenOption.DELETE_ON_CLOSE);
        }
        if (options.isSparse()) {
            opts.add(StandardOpenOption.SPARSE);
        }
        if (options.isTruncateExisting()) {
            opts.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        try {
            if (options.getPerms() != null) {
                FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(options.getPerms()));
                this.ch = AsynchronousFileChannel.open(file, opts, vertx.getWorkerPool(), attrs);
            } else {
                this.ch = AsynchronousFileChannel.open(file, opts, vertx.getWorkerPool(), new FileAttribute[0]);
            }
            if (options.isAppend()) {
                this.writePos = this.ch.size();
            }
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        this.context = context;
        this.queue = new InboundBuffer(context, 0L);
        this.queue.handler((E buff) -> {
            if (buff.length() > 0) {
                this.handleBuffer((Buffer)buff);
            } else {
                this.handleEnd();
            }
        });
        this.queue.drainHandler((Void v) -> this.doRead());
    }

    @Override
    public void close() {
        this.closeInternal(null);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.closeInternal(handler);
    }

    @Override
    public void end() {
        this.close();
    }

    @Override
    public synchronized AsyncFile read(Buffer buffer, int offset, long position, int length, Handler<AsyncResult<Buffer>> handler) {
        Objects.requireNonNull(buffer, "buffer");
        Objects.requireNonNull(handler, "handler");
        Arguments.require(offset >= 0, "offset must be >= 0");
        Arguments.require(position >= 0L, "position must be >= 0");
        Arguments.require(length >= 0, "length must be >= 0");
        this.check();
        ByteBuffer bb = ByteBuffer.allocate(length);
        this.doRead(buffer, offset, bb, position, handler);
        return this;
    }

    @Override
    public AsyncFile fetch(long amount) {
        this.queue.fetch(amount);
        return this;
    }

    @Override
    public AsyncFile write(Buffer buffer, long position, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.doWrite(buffer, position, handler);
    }

    private synchronized AsyncFile doWrite(Buffer buffer, long position, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(buffer, "buffer");
        Arguments.require(position >= 0L, "position must be >= 0");
        this.check();
        Handler<AsyncResult<Void>> wrapped = ar -> {
            if (ar.succeeded()) {
                Runnable action;
                this.checkContext();
                AsyncFileImpl asyncFileImpl = this;
                synchronized (asyncFileImpl) {
                    action = this.writesOutstanding == 0L && this.closedDeferred != null ? this.closedDeferred : this::checkDrained;
                }
                action.run();
                if (handler != null) {
                    handler.handle((AsyncResult<Void>)ar);
                }
            } else if (handler != null) {
                handler.handle((AsyncResult<Void>)ar);
            } else {
                this.handleException(ar.cause());
            }
        };
        ByteBuf buf = buffer.getByteBuf();
        if (buf.nioBufferCount() > 1) {
            this.doWrite(buf.nioBuffers(), position, wrapped);
        } else {
            ByteBuffer bb = buf.nioBuffer();
            this.doWrite(bb, position, bb.limit(), wrapped);
        }
        return this;
    }

    @Override
    public synchronized AsyncFile write(Buffer buffer) {
        int length = buffer.length();
        this.doWrite(buffer, this.writePos, null);
        this.writePos += (long)length;
        return this;
    }

    @Override
    public synchronized AsyncFile setWriteQueueMaxSize(int maxSize) {
        Arguments.require(maxSize >= 2, "maxSize must be >= 2");
        this.check();
        this.maxWrites = maxSize;
        this.lwm = this.maxWrites / 2;
        return this;
    }

    @Override
    public synchronized AsyncFile setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    @Override
    public synchronized boolean writeQueueFull() {
        this.check();
        return this.writesOutstanding >= (long)this.maxWrites;
    }

    @Override
    public synchronized AsyncFile drainHandler(Handler<Void> handler) {
        this.check();
        this.drainHandler = handler;
        this.checkDrained();
        return this;
    }

    @Override
    public synchronized AsyncFile exceptionHandler(Handler<Throwable> handler) {
        this.check();
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized AsyncFile handler(Handler<Buffer> handler) {
        this.check();
        if (this.closed) {
            return this;
        }
        this.handler = handler;
        if (handler != null) {
            this.doRead();
        } else {
            this.queue.clear();
        }
        return this;
    }

    @Override
    public synchronized AsyncFile endHandler(Handler<Void> handler) {
        this.check();
        this.endHandler = handler;
        return this;
    }

    @Override
    public synchronized AsyncFile pause() {
        this.check();
        this.queue.pause();
        return this;
    }

    @Override
    public synchronized AsyncFile resume() {
        this.check();
        if (!this.closed) {
            this.queue.resume();
        }
        return this;
    }

    @Override
    public AsyncFile flush() {
        this.doFlush(null);
        return this;
    }

    @Override
    public AsyncFile flush(Handler<AsyncResult<Void>> handler) {
        this.doFlush(handler);
        return this;
    }

    @Override
    public synchronized AsyncFile setReadPos(long readPos) {
        this.readPos = readPos;
        return this;
    }

    @Override
    public synchronized AsyncFile setWritePos(long writePos) {
        this.writePos = writePos;
        return this;
    }

    @Override
    public synchronized long getWritePos() {
        return this.writePos;
    }

    private synchronized void checkDrained() {
        if (this.drainHandler != null && this.writesOutstanding <= (long)this.lwm) {
            Handler<Void> handler = this.drainHandler;
            this.drainHandler = null;
            handler.handle(null);
        }
    }

    private void handleException(Throwable t) {
        if (this.exceptionHandler != null && t instanceof Exception) {
            this.exceptionHandler.handle(t);
        } else {
            log.error((Object)"Unhandled exception", t);
        }
    }

    private synchronized void doWrite(ByteBuffer[] buffers, long position, Handler<AsyncResult<Void>> handler) {
        AtomicInteger cnt = new AtomicInteger();
        AtomicBoolean sentFailure = new AtomicBoolean();
        for (ByteBuffer b : buffers) {
            int limit = b.limit();
            this.doWrite(b, position, limit, ar -> {
                if (ar.succeeded()) {
                    if (cnt.incrementAndGet() == buffers.length) {
                        handler.handle((AsyncResult<Void>)ar);
                    }
                } else if (sentFailure.compareAndSet(false, true)) {
                    handler.handle((AsyncResult<Void>)ar);
                }
            });
            position += (long)limit;
        }
    }

    private void doRead() {
        this.doRead(ByteBuffer.allocate(this.readBufferSize));
    }

    private synchronized void doRead(ByteBuffer bb) {
        Buffer buff = Buffer.buffer(this.readBufferSize);
        this.doRead(buff, 0, bb, this.readPos, ar -> {
            if (ar.succeeded()) {
                Buffer buffer = (Buffer)ar.result();
                this.readPos += (long)buffer.length();
                if (this.queue.write(buffer) && buffer.length() > 0) {
                    this.doRead(bb);
                }
            } else {
                this.handleException(ar.cause());
            }
        });
    }

    private synchronized void handleBuffer(Buffer buff) {
        if (this.handler != null) {
            this.checkContext();
            this.handler.handle(buff);
        }
    }

    private synchronized void handleEnd() {
        this.handler = null;
        if (this.endHandler != null) {
            this.checkContext();
            this.endHandler.handle(null);
        }
    }

    private synchronized void doFlush(Handler<AsyncResult<Void>> handler) {
        this.checkClosed();
        this.context.executeBlockingInternal(fut -> {
            try {
                this.ch.force(false);
                fut.complete();
            }
            catch (IOException e) {
                throw new FileSystemException(e);
            }
        }, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(ByteBuffer buff, long position, long toWrite, Handler<AsyncResult<Void>> handler) {
        if (toWrite > 0L) {
            AsyncFileImpl asyncFileImpl = this;
            synchronized (asyncFileImpl) {
                this.writesOutstanding += toWrite;
            }
            this.writeInternal(buff, position, handler);
        } else {
            handler.handle(Future.succeededFuture());
        }
    }

    private void writeInternal(final ByteBuffer buff, final long position, final Handler<AsyncResult<Void>> handler) {
        this.ch.write(buff, position, null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer bytesWritten, Object attachment) {
                long pos = position;
                if (buff.hasRemaining()) {
                    AsyncFileImpl.this.writeInternal(buff, pos += (long)bytesWritten.intValue(), handler);
                } else {
                    AsyncFileImpl.this.context.runOnContext(v -> {
                        AsyncFileImpl asyncFileImpl = AsyncFileImpl.this;
                        synchronized (asyncFileImpl) {
                            AsyncFileImpl.this.writesOutstanding = AsyncFileImpl.this.writesOutstanding - (long)buff.limit();
                        }
                        handler.handle(Future.succeededFuture());
                    });
                }
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                if (exc instanceof Exception) {
                    AsyncFileImpl.this.context.runOnContext(v -> handler.handle(Future.failedFuture(exc)));
                } else {
                    log.error((Object)"Error occurred", exc);
                }
            }
        });
    }

    private void doRead(final Buffer writeBuff, final int offset, final ByteBuffer buff, final long position, final Handler<AsyncResult<Buffer>> handler) {
        this.ch.read(buff, position, null, new CompletionHandler<Integer, Object>(){
            long pos;
            {
                this.pos = position;
            }

            private void done() {
                AsyncFileImpl.this.context.runOnContext(v -> {
                    buff.flip();
                    writeBuff.setBytes(offset, buff);
                    buff.compact();
                    handler.handle(Future.succeededFuture(writeBuff));
                });
            }

            @Override
            public void completed(Integer bytesRead, Object attachment) {
                if (bytesRead == -1) {
                    this.done();
                } else if (buff.hasRemaining()) {
                    this.pos += (long)bytesRead.intValue();
                    AsyncFileImpl.this.doRead(writeBuff, offset, buff, this.pos, handler);
                } else {
                    this.done();
                }
            }

            @Override
            public void failed(Throwable t, Object attachment) {
                AsyncFileImpl.this.context.runOnContext(v -> handler.handle(Future.failedFuture(t)));
            }
        });
    }

    private void check() {
        this.checkClosed();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("File handle is closed");
        }
    }

    private void checkContext() {
        if (!this.vertx.getContext().equals(this.context)) {
            throw new IllegalStateException("AsyncFile must only be used in the context that created it, expected: " + this.context + " actual " + this.vertx.getContext());
        }
    }

    private void doClose(Handler<AsyncResult<Void>> handler) {
        ContextInternal handlerContext = this.vertx.getOrCreateContext();
        handlerContext.executeBlockingInternal(res -> {
            try {
                this.ch.close();
                res.complete(null);
            }
            catch (IOException e) {
                res.fail(e);
            }
        }, handler);
    }

    private synchronized void closeInternal(Handler<AsyncResult<Void>> handler) {
        this.check();
        this.closed = true;
        if (this.writesOutstanding == 0L) {
            this.doClose(handler);
        } else {
            this.closedDeferred = () -> this.doClose(handler);
        }
    }
}

