/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.net.impl.URIDecoder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileResolver {
    public static final String DISABLE_FILE_CACHING_PROP_NAME = "vertx.disableFileCaching";
    public static final String DISABLE_CP_RESOLVING_PROP_NAME = "vertx.disableFileCPResolving";
    public static final String CACHE_DIR_BASE_PROP_NAME = "vertx.cacheDirBase";
    private static final String DEFAULT_CACHE_DIR_BASE = ".vertx";
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final boolean NON_UNIX_FILE_SEP = !FILE_SEP.equals("/");
    private static final boolean ENABLE_CP_RESOLVING = !Boolean.getBoolean("vertx.disableFileCPResolving");
    private static final String CACHE_DIR_BASE = System.getProperty("vertx.cacheDirBase", ".vertx");
    private static final String JAR_URL_SEP = "!/";
    private static final Pattern JAR_URL_SEP_PATTERN = Pattern.compile("!/");
    private final Vertx vertx;
    private final File cwd;
    private File cacheDir;
    private Thread shutdownHook;
    private final boolean enableCaching;

    public FileResolver(Vertx vertx) {
        this(vertx, VertxOptions.DEFAULT_FILE_CACHING_ENABLED);
    }

    public FileResolver(Vertx vertx, boolean enableCaching) {
        this.vertx = vertx;
        this.enableCaching = enableCaching;
        String cwdOverride = System.getProperty("vertx.cwd");
        this.cwd = cwdOverride != null ? new File(cwdOverride).getAbsoluteFile() : null;
        if (ENABLE_CP_RESOLVING) {
            this.setupCacheDir();
        }
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.deleteCacheDir(handler);
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File resolveFile(String fileName) {
        File file = new File(fileName);
        if (this.cwd != null && !file.isAbsolute()) {
            file = new File(this.cwd, fileName);
        }
        if (!ENABLE_CP_RESOLVING) {
            return file;
        }
        FileResolver fileResolver = this;
        synchronized (fileResolver) {
            if (!file.exists()) {
                URL url;
                URL directoryContents;
                String parentFileName;
                File cacheFile = new File(this.cacheDir, fileName);
                if (this.enableCaching && cacheFile.exists()) {
                    return cacheFile;
                }
                ClassLoader cl = this.getClassLoader();
                if (NON_UNIX_FILE_SEP) {
                    fileName = fileName.replace(FILE_SEP, "/");
                }
                if ((parentFileName = file.getParent()) != null && (directoryContents = cl.getResource(parentFileName)) != null) {
                    this.unpackUrlResource(directoryContents, parentFileName, cl, true);
                }
                if ((url = cl.getResource(fileName)) != null) {
                    return this.unpackUrlResource(url, fileName, cl, false);
                }
            }
        }
        return file;
    }

    private File unpackUrlResource(URL url, String fileName, ClassLoader cl, boolean isDir) {
        String prot;
        switch (prot = url.getProtocol()) {
            case "file": {
                return this.unpackFromFileURL(url, fileName, cl);
            }
            case "jar": {
                return this.unpackFromJarURL(url, fileName, cl);
            }
            case "bundle": 
            case "bundleentry": 
            case "bundleresource": {
                return this.unpackFromBundleURL(url, isDir);
            }
        }
        throw new IllegalStateException("Invalid url protocol: " + prot);
    }

    private synchronized File unpackFromFileURL(URL url, String fileName, ClassLoader cl) {
        File resource = new File(URIDecoder.decodeURIComponent(url.getPath(), false));
        boolean isDirectory = resource.isDirectory();
        File cacheFile = new File(this.cacheDir, fileName);
        if (!isDirectory) {
            cacheFile.getParentFile().mkdirs();
            try {
                if (this.enableCaching) {
                    Files.copy(resource.toPath(), cacheFile.toPath(), new CopyOption[0]);
                }
                Files.copy(resource.toPath(), cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new VertxException(e);
            }
        } else {
            String[] listing;
            cacheFile.mkdirs();
            for (String file : listing = resource.list()) {
                String subResource = fileName + "/" + file;
                URL url2 = cl.getResource(subResource);
                this.unpackFromFileURL(url2, subResource, cl);
            }
        }
        return cacheFile;
    }

    private synchronized File unpackFromJarURL(URL url, String fileName, ClassLoader cl) {
        ZipFile zip = null;
        try {
            int idx2;
            String path = url.getPath();
            int idx1 = path.lastIndexOf(".jar!");
            if (idx1 == -1) {
                idx1 = path.lastIndexOf(".zip!");
            }
            if ((idx2 = path.lastIndexOf(".jar!", idx1 - 1)) == -1) {
                idx2 = path.lastIndexOf(".zip!", idx1 - 1);
            }
            if (idx2 == -1) {
                File file = new File(URIDecoder.decodeURIComponent(path.substring(5, idx1 + 4), false));
                zip = new ZipFile(file);
            } else {
                String s = path.substring(idx2 + 6, idx1 + 4);
                File file = this.resolveFile(s);
                zip = new ZipFile(file);
            }
            String inJarPath = path.substring(idx1 + 6);
            String[] parts = JAR_URL_SEP_PATTERN.split(inJarPath);
            StringBuilder prefixBuilder = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                prefixBuilder.append(parts[i]).append("/");
            }
            String prefix = prefixBuilder.toString();
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(prefix.isEmpty() ? fileName : prefix + fileName)) continue;
                File file = new File(this.cacheDir, prefix.isEmpty() ? name : name.substring(prefix.length()));
                if (name.endsWith("/")) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                try {
                    InputStream is = zip.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        if (this.enableCaching) {
                            Files.copy(is, file.toPath(), new CopyOption[0]);
                            continue;
                        }
                        Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {}
            }
            this.closeQuietly(zip);
        }
        catch (IOException e) {
            try {
                throw new VertxException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(zip);
                throw throwable;
            }
        }
        return new File(this.cacheDir, fileName);
    }

    private void closeQuietly(Closeable zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isBundleUrlDirectory(URL url) {
        return url.toExternalForm().endsWith("/") || this.getClassLoader().getResource(url.getPath().substring(1) + "/") != null;
    }

    private synchronized File unpackFromBundleURL(URL url, boolean isDir) {
        block19: {
            try {
                File file = new File(this.cacheDir, url.getHost() + File.separator + url.getFile());
                file.getParentFile().mkdirs();
                if (this.getClassLoader() != null && this.isBundleUrlDirectory(url) || isDir) {
                    file.mkdirs();
                    break block19;
                }
                file.getParentFile().mkdirs();
                try (InputStream is = url.openStream();){
                    if (this.enableCaching) {
                        Files.copy(is, file.toPath(), new CopyOption[0]);
                    } else {
                        Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {}
            }
            catch (IOException e) {
                throw new VertxException(e);
            }
        }
        return new File(this.cacheDir, url.getHost() + File.separator + url.getFile());
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }

    private void setupCacheDir() {
        String cacheDirName = CACHE_DIR_BASE + "/file-cache-" + UUID.randomUUID().toString();
        this.cacheDir = new File(cacheDirName);
        if (!this.cacheDir.mkdirs()) {
            throw new IllegalStateException("Failed to create cache dir");
        }
        this.shutdownHook = new Thread(() -> {
            CountDownLatch latch = new CountDownLatch(1);
            this.deleteCacheDir(ar -> latch.countDown());
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void deleteCacheDir(Handler<AsyncResult<Void>> handler) {
        if (this.cacheDir != null && this.cacheDir.exists()) {
            this.vertx.fileSystem().deleteRecursive(this.cacheDir.getAbsolutePath(), true, handler);
        } else {
            handler.handle(Future.succeededFuture());
        }
    }
}

