/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.testtools;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.DnsServer;
import org.apache.directory.server.dns.io.encoder.DnsMessageEncoder;
import org.apache.directory.server.dns.io.encoder.ResourceRecordEncoder;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResourceRecordModifier;
import org.apache.directory.server.dns.protocol.DnsProtocolHandler;
import org.apache.directory.server.dns.protocol.DnsUdpDecoder;
import org.apache.directory.server.dns.protocol.DnsUdpEncoder;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.transport.socket.DatagramAcceptor;
import org.apache.mina.transport.socket.DatagramSessionConfig;

public final class TestDnsServer
extends DnsServer {
    public static final int PORT = 53530;
    private final RecordStore store;

    private TestDnsServer(RecordStore store) {
        this.store = store;
    }

    public static TestDnsServer testResolveA(final String ipAddress) {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.A);
                rm.put("apacheDnsIpAddress", ipAddress);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public static TestDnsServer testResolveAAAA(final String ipAddress) {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.AAAA);
                rm.put("apacheDnsIpAddress", ipAddress);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public static TestDnsServer testResolveMX(final int prio, final String mxRecord) {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.MX);
                rm.put("apacheDnsMxPreference", String.valueOf(prio));
                rm.put("apacheDnsDomainName", mxRecord);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public static TestDnsServer testResolveTXT(final String txt) {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.TXT);
                rm.put("apacheDnsCharacterString", txt);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public static TestDnsServer testResolveNS(final String ns) {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.NS);
                rm.put("apacheDnsDomainName", ns);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public static TestDnsServer testResolveCNAME(final String cname) {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.CNAME);
                rm.put("apacheDnsDomainName", cname);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public static TestDnsServer testResolvePTR(final String ptr) {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.PTR);
                rm.put("apacheDnsDomainName", ptr);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public static TestDnsServer testResolveSRV(final int priority, final int weight, final int port, final String target) {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.SRV);
                rm.put("apacheDnsServicePriority", String.valueOf(priority));
                rm.put("apacheDnsServiceWeight", String.valueOf(weight));
                rm.put("apacheDnsServicePort", String.valueOf(port));
                rm.put("apacheDnsDomainName", target);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public static TestDnsServer testLookup4(final String ip) {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.A);
                rm.put("apacheDnsIpAddress", ip);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public static TestDnsServer testLookup6() {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.AAAA);
                rm.put("apacheDnsIpAddress", "::1");
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public static TestDnsServer testLookup(String ip) {
        return TestDnsServer.testLookup4(ip);
    }

    public static TestDnsServer testLookupNonExisting() {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                return null;
            }
        });
    }

    public static TestDnsServer testReverseLookup(final String ptr) {
        return new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) throws DnsException {
                HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("dns.vertx.io");
                rm.setDnsTtl(100);
                rm.setDnsType(RecordType.PTR);
                rm.put("apacheDnsDomainName", ptr);
                set.add(rm.getEntry());
                return set;
            }
        });
    }

    public void start() throws IOException {
        UdpTransport transport = new UdpTransport("127.0.0.1", 53530);
        this.setTransports(new Transport[]{transport});
        DatagramAcceptor acceptor = transport.getAcceptor();
        acceptor.setHandler((IoHandler)new DnsProtocolHandler(this, this.store){

            public void sessionCreated(IoSession session) throws Exception {
                session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TestDnsProtocolUdpCodecFactory()));
            }
        });
        ((DatagramSessionConfig)acceptor.getSessionConfig()).setReuseAddress(true);
        acceptor.bind();
    }

    private final class TestDnsProtocolUdpCodecFactory
    implements ProtocolCodecFactory {
        private DnsMessageEncoder encoder = new DnsMessageEncoder();
        private TestAAAARecordEncoder recordEncoder = new TestAAAARecordEncoder();

        private TestDnsProtocolUdpCodecFactory() {
        }

        public ProtocolEncoder getEncoder(IoSession session) throws Exception {
            return new DnsUdpEncoder(){

                public void encode(IoSession session, Object message, ProtocolEncoderOutput out) {
                    IoBuffer buf = IoBuffer.allocate((int)1024);
                    DnsMessage dnsMessage = (DnsMessage)message;
                    TestDnsProtocolUdpCodecFactory.this.encoder.encode(buf, dnsMessage);
                    for (ResourceRecord record : dnsMessage.getAnswerRecords()) {
                        if (record.getRecordType() != RecordType.AAAA) continue;
                        try {
                            TestDnsProtocolUdpCodecFactory.this.recordEncoder.put(buf, record);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    buf.flip();
                    out.write((Object)buf);
                }
            };
        }

        public ProtocolDecoder getDecoder(IoSession session) throws Exception {
            return new DnsUdpDecoder();
        }

        private final class TestAAAARecordEncoder
        extends ResourceRecordEncoder {
            private TestAAAARecordEncoder() {
            }

            protected void putResourceRecordData(IoBuffer ioBuffer, ResourceRecord resourceRecord) {
                if (!resourceRecord.get("apacheDnsIpAddress").equals("::1")) {
                    throw new IllegalStateException("Only supposed to be used with IPV6 address of ::1");
                }
                ioBuffer.put(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
            }
        }
    }
}

