/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.remoting.parser;

import io.seata.common.exception.FrameworkException;
import io.seata.common.util.ReflectionUtil;
import io.seata.rm.tcc.remoting.Protocols;
import io.seata.rm.tcc.remoting.RemotingDesc;
import io.seata.rm.tcc.remoting.parser.AbstractedRemotingParser;

public class SofaRpcRemotingParser
extends AbstractedRemotingParser {
    @Override
    public boolean isReference(Object bean, String beanName) throws FrameworkException {
        String beanClassName = bean.getClass().getName();
        return "com.alipay.sofa.runtime.spring.factory.ReferenceFactoryBean".equals(beanClassName);
    }

    @Override
    public boolean isService(Object bean, String beanName) throws FrameworkException {
        String beanClassName = bean.getClass().getName();
        return "com.alipay.sofa.runtime.spring.factory.ServiceFactoryBean".equals(beanClassName);
    }

    @Override
    public RemotingDesc getServiceDesc(Object bean, String beanName) throws FrameworkException {
        if (!this.isRemoting(bean, beanName)) {
            return null;
        }
        try {
            RemotingDesc serviceBeanDesc = new RemotingDesc();
            Class interfaceClass = (Class)ReflectionUtil.invokeMethod((Object)bean, (String)"getInterfaceClass");
            String interfaceClassName = (String)ReflectionUtil.getFieldValue((Object)bean, (String)"interfaceType");
            String uniqueId = (String)ReflectionUtil.getFieldValue((Object)bean, (String)"uniqueId");
            serviceBeanDesc.setInterfaceClass(interfaceClass);
            serviceBeanDesc.setInterfaceClassName(interfaceClassName);
            serviceBeanDesc.setUniqueId(uniqueId);
            serviceBeanDesc.setProtocol(Protocols.SOFA_RPC);
            if (this.isService(bean, beanName)) {
                Object targetBean = ReflectionUtil.getFieldValue((Object)bean, (String)"ref");
                serviceBeanDesc.setTargetBean(targetBean);
            }
            return serviceBeanDesc;
        }
        catch (Throwable t) {
            throw new FrameworkException(t);
        }
    }

    @Override
    public short getProtocol() {
        return Protocols.SOFA_RPC;
    }
}

