/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.interceptor;

import com.alibaba.fastjson.JSON;
import io.seata.common.exception.FrameworkException;
import io.seata.common.executor.Callback;
import io.seata.common.util.NetUtil;
import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.tcc.api.BusinessActionContext;
import io.seata.rm.tcc.api.BusinessActionContextParameter;
import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import io.seata.rm.tcc.interceptor.ActionContextUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionInterceptorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionInterceptorHandler.class);

    public Map<String, Object> proceed(Method method, Object[] arguments, TwoPhaseBusinessAction businessAction, Callback<Object> targetCallback) throws Throwable {
        HashMap<String, Object> ret = new HashMap<String, Object>(16);
        String actionName = businessAction.name();
        String xid = RootContext.getXID();
        BusinessActionContext actionContext = new BusinessActionContext();
        actionContext.setXid(xid);
        actionContext.setActionName(actionName);
        String branchId = this.doTccActionLogStore(method, arguments, businessAction, actionContext);
        actionContext.setBranchId(branchId);
        Class<?>[] types = method.getParameterTypes();
        int argIndex = 0;
        for (Class<?> cls : types) {
            if (cls.getName().equals(BusinessActionContext.class.getName())) {
                arguments[argIndex] = actionContext;
                break;
            }
            ++argIndex;
        }
        ret.put("arguments", arguments);
        ret.put("result", targetCallback.execute());
        return ret;
    }

    protected String doTccActionLogStore(Method method, Object[] arguments, TwoPhaseBusinessAction businessAction, BusinessActionContext actionContext) {
        String actionName = actionContext.getActionName();
        String xid = actionContext.getXid();
        Map<String, Object> context = this.fetchActionRequestContext(method, arguments);
        context.put("action-start-time", System.currentTimeMillis());
        this.initBusinessContext(context, method, businessAction);
        this.initFrameworkContext(context);
        actionContext.setActionContext(context);
        HashMap<String, Map<String, Object>> applicationContext = new HashMap<String, Map<String, Object>>(4);
        applicationContext.put("actionContext", context);
        String applicationContextStr = JSON.toJSONString(applicationContext);
        try {
            Long branchId = DefaultResourceManager.get().branchRegister(BranchType.TCC, actionName, null, xid, applicationContextStr, null);
            return String.valueOf(branchId);
        }
        catch (Throwable t) {
            String msg = "TCC branch Register error, xid:" + xid;
            LOGGER.error(msg, t);
            throw new FrameworkException(t, msg);
        }
    }

    protected void initFrameworkContext(Map<String, Object> context) {
        try {
            context.put("host-name", NetUtil.getLocalIp());
        }
        catch (Throwable t) {
            LOGGER.warn("getLocalIP error", t);
        }
    }

    protected void initBusinessContext(Map<String, Object> context, Method method, TwoPhaseBusinessAction businessAction) {
        if (method != null) {
            context.put("sys::prepare", method.getName());
        }
        if (businessAction != null) {
            context.put("sys::commit", businessAction.commitMethod());
            context.put("sys::rollback", businessAction.rollbackMethod());
            context.put("actionName", businessAction.name());
        }
    }

    protected Map<String, Object> fetchActionRequestContext(Method method, Object[] arguments) {
        HashMap<String, Object> context = new HashMap<String, Object>(8);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                if (!(parameterAnnotations[i][j] instanceof BusinessActionContextParameter)) continue;
                BusinessActionContextParameter param = (BusinessActionContextParameter)parameterAnnotations[i][j];
                if (null == arguments[i]) {
                    throw new IllegalArgumentException("@BusinessActionContextParameter 's params can not null");
                }
                Object paramObject = arguments[i];
                int index = param.index();
                if (index >= 0) {
                    Object targetParam = ((List)paramObject).get(index);
                    if (param.isParamInProperty()) {
                        context.putAll(ActionContextUtil.fetchContextFromObject(targetParam));
                        continue;
                    }
                    context.put(param.paramName(), targetParam);
                    continue;
                }
                if (param.isParamInProperty()) {
                    context.putAll(ActionContextUtil.fetchContextFromObject(paramObject));
                    continue;
                }
                context.put(param.paramName(), paramObject);
            }
        }
        return context;
    }
}

