/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.annotation;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.StringUtils;
import io.seata.rm.GlobalLockTemplate;
import io.seata.spring.annotation.GlobalLock;
import io.seata.spring.annotation.GlobalTransactional;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.TransactionalTemplate;
import io.seata.tm.api.transaction.NoRollbackRule;
import io.seata.tm.api.transaction.RollbackRule;
import io.seata.tm.api.transaction.TransactionInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;

public class GlobalTransactionalInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalTransactionalInterceptor.class);
    private static final FailureHandler DEFAULT_FAIL_HANDLER = new DefaultFailureHandlerImpl();
    private final TransactionalTemplate transactionalTemplate = new TransactionalTemplate();
    private final GlobalLockTemplate<Object> globalLockTemplate = new GlobalLockTemplate();
    private final FailureHandler failureHandler;

    public GlobalTransactionalInterceptor(FailureHandler failureHandler) {
        if (null == failureHandler) {
            failureHandler = DEFAULT_FAIL_HANDLER;
        }
        this.failureHandler = failureHandler;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Class targetClass = methodInvocation.getThis() != null ? AopUtils.getTargetClass((Object)methodInvocation.getThis()) : null;
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)methodInvocation.getMethod(), (Class)targetClass);
        Method method = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
        GlobalTransactional globalTransactionalAnnotation = this.getAnnotation(method, GlobalTransactional.class);
        GlobalLock globalLockAnnotation = this.getAnnotation(method, GlobalLock.class);
        if (globalTransactionalAnnotation != null) {
            return this.handleGlobalTransaction(methodInvocation, globalTransactionalAnnotation);
        }
        if (globalLockAnnotation != null) {
            return this.handleGlobalLock(methodInvocation);
        }
        return methodInvocation.proceed();
    }

    private Object handleGlobalLock(final MethodInvocation methodInvocation) throws Exception {
        return this.globalLockTemplate.execute((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return methodInvocation.proceed();
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private Object handleGlobalTransaction(final MethodInvocation methodInvocation, final GlobalTransactional globalTrxAnno) throws Throwable {
        try {
            return this.transactionalTemplate.execute(new TransactionalExecutor(){

                public Object execute() throws Throwable {
                    return methodInvocation.proceed();
                }

                public String name() {
                    String name = globalTrxAnno.name();
                    if (!StringUtils.isNullOrEmpty((String)name)) {
                        return name;
                    }
                    return GlobalTransactionalInterceptor.this.formatMethod(methodInvocation.getMethod());
                }

                public TransactionInfo getTransactionInfo() {
                    TransactionInfo transactionInfo = new TransactionInfo();
                    transactionInfo.setTimeOut(globalTrxAnno.timeoutMills());
                    transactionInfo.setName(this.name());
                    LinkedHashSet<Object> rollbackRules = new LinkedHashSet<Object>();
                    for (Class<? extends Throwable> clazz : globalTrxAnno.rollbackFor()) {
                        rollbackRules.add(new RollbackRule(clazz));
                    }
                    for (String string : globalTrxAnno.rollbackForClassName()) {
                        rollbackRules.add(new RollbackRule(string));
                    }
                    for (Class<? extends Throwable> clazz : globalTrxAnno.noRollbackFor()) {
                        rollbackRules.add(new NoRollbackRule((Class)clazz));
                    }
                    for (String string : globalTrxAnno.noRollbackForClassName()) {
                        rollbackRules.add(new NoRollbackRule(string));
                    }
                    transactionInfo.setRollbackRules(rollbackRules);
                    return transactionInfo;
                }
            });
        }
        catch (TransactionalExecutor.ExecutionException e) {
            TransactionalExecutor.Code code = e.getCode();
            switch (code) {
                case RollbackDone: {
                    throw e.getOriginalException();
                }
                case BeginFailure: {
                    this.failureHandler.onBeginFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
                case CommitFailure: {
                    this.failureHandler.onCommitFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
                case RollbackFailure: {
                    this.failureHandler.onRollbackFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
            }
            throw new ShouldNeverHappenException("Unknown TransactionalExecutor.Code: " + code);
        }
    }

    private <T extends Annotation> T getAnnotation(Method method, Class<T> clazz) {
        if (method == null) {
            return null;
        }
        return method.getAnnotation(clazz);
    }

    private String formatMethod(Method method) {
        String paramTypes = Arrays.stream(method.getParameterTypes()).map(Class::getName).reduce((p1, p2) -> String.format("%s, %s", p1, p2)).orElse("");
        return method.getName() + "(" + paramTypes + ")";
    }
}

