/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry.custom;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.RegistryProvider;
import io.seata.discovery.registry.RegistryService;
import io.seata.discovery.registry.RegistryType;
import java.util.stream.Stream;

@LoadLevel(name="Custom")
public class CustomRegistryProvider
implements RegistryProvider {
    private static final String FILE_CONFIG_KEY_PREFIX = "registry.custom.name";
    private final String CUSTOM_NAME;

    public CustomRegistryProvider() {
        String name = ConfigurationFactory.CURRENT_FILE_INSTANCE.getConfig(FILE_CONFIG_KEY_PREFIX);
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name value of custom registry type must not be blank");
        }
        if (Stream.of(RegistryType.values()).anyMatch(ct -> ct.name().equalsIgnoreCase(name))) {
            throw new IllegalArgumentException(String.format("custom registry type name %s is not allowed", name));
        }
        this.CUSTOM_NAME = name;
    }

    public RegistryService provide() {
        return ((RegistryProvider)EnhancedServiceLoader.load(RegistryProvider.class, (String)this.CUSTOM_NAME)).provide();
    }
}

