/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol.transaction;

import io.netty.buffer.ByteBuf;
import io.seata.core.model.BranchStatus;
import io.seata.core.protocol.transaction.AbstractTransactionResponse;
import java.nio.ByteBuffer;

public abstract class AbstractBranchEndResponse
extends AbstractTransactionResponse {
    protected String xid;
    protected long branchId;
    protected BranchStatus branchStatus;

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public long getBranchId() {
        return this.branchId;
    }

    public void setBranchId(long branchId) {
        this.branchId = branchId;
    }

    public BranchStatus getBranchStatus() {
        return this.branchStatus;
    }

    public void setBranchStatus(BranchStatus branchStatus) {
        this.branchStatus = branchStatus;
    }

    @Override
    protected void doEncode() {
        super.doEncode();
        if (this.xid != null) {
            byte[] bs = this.xid.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        this.byteBuffer.putLong(this.branchId);
        this.byteBuffer.put((byte)this.branchStatus.getCode());
    }

    @Override
    public void decode(ByteBuffer byteBuffer) {
        super.decode(byteBuffer);
        short xidLen = byteBuffer.getShort();
        if (xidLen > 0) {
            byte[] bs = new byte[xidLen];
            byteBuffer.get(bs);
            this.setXid(new String(bs, UTF8));
        }
        this.branchId = byteBuffer.getLong();
        this.branchStatus = BranchStatus.get(byteBuffer.get());
    }

    @Override
    public boolean decode(ByteBuf in) {
        boolean s = super.decode(in);
        if (!s) {
            return s;
        }
        short xidLen = in.readShort();
        if (xidLen > 0) {
            byte[] bs = new byte[xidLen];
            in.readBytes(bs);
            this.setXid(new String(bs, UTF8));
        }
        this.branchId = in.readLong();
        this.branchStatus = BranchStatus.get(in.readByte());
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("xid=");
        result.append(this.xid);
        result.append(",");
        result.append("branchId=");
        result.append(this.branchId);
        result.append(",");
        result.append("branchStatus=");
        result.append((Object)this.branchStatus);
        result.append(",");
        result.append("result code =");
        result.append((Object)this.getResultCode());
        result.append(",");
        result.append("getMsg =");
        result.append(this.getMsg());
        return result.toString();
    }
}

