/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.seata.core.protocol.RpcMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MessageFuture {
    private RpcMessage requestMessage;
    private long timeout;
    private long start = System.currentTimeMillis();
    private volatile Object resultMessage;
    private static final Object NULL = new Object();
    private final CountDownLatch latch = new CountDownLatch(1);

    public boolean isTimeout() {
        return System.currentTimeMillis() - this.start > this.timeout;
    }

    public Object get(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        boolean success = this.latch.await(timeout, unit);
        if (!success) {
            throw new TimeoutException("cost " + (System.currentTimeMillis() - this.start) + " ms");
        }
        if (this.resultMessage instanceof RuntimeException) {
            throw (RuntimeException)this.resultMessage;
        }
        if (this.resultMessage instanceof Throwable) {
            throw new RuntimeException((Throwable)this.resultMessage);
        }
        return this.resultMessage;
    }

    public void setResultMessage(Object obj) {
        this.resultMessage = obj == null ? NULL : obj;
        this.latch.countDown();
    }

    public RpcMessage getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(RpcMessage requestMessage) {
        this.requestMessage = requestMessage;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

