/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.netty.buffer.ByteBuf;
import io.seata.core.protocol.AbstractMessage;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIdentifyRequest
extends AbstractMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIdentifyRequest.class);
    protected String version = "0.5.0";
    protected String applicationId;
    protected String transactionServiceGroup;
    protected String extraData;
    public ByteBuffer byteBuffer = ByteBuffer.allocate(10240);

    public AbstractIdentifyRequest(String applicationId, String transactionServiceGroup) {
        this.applicationId = applicationId;
        this.transactionServiceGroup = transactionServiceGroup;
    }

    public AbstractIdentifyRequest(String applicationId, String transactionServiceGroup, String extraData) {
        this.applicationId = applicationId;
        this.transactionServiceGroup = transactionServiceGroup;
        this.extraData = extraData;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTransactionServiceGroup() {
        return this.transactionServiceGroup;
    }

    public void setTransactionServiceGroup(String transactionServiceGroup) {
        this.transactionServiceGroup = transactionServiceGroup;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    protected void doEncode() {
        byte[] bs;
        this.byteBuffer.clear();
        if (this.version != null) {
            bs = this.version.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        if (this.applicationId != null) {
            bs = this.applicationId.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        if (this.transactionServiceGroup != null) {
            bs = this.transactionServiceGroup.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        if (this.extraData != null) {
            bs = this.extraData.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
    }

    private final byte[] flushEncode() {
        this.byteBuffer.flip();
        byte[] content = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(content);
        this.byteBuffer.clear();
        return content;
    }

    @Override
    public final byte[] encode() {
        this.doEncode();
        return this.flushEncode();
    }

    @Override
    public boolean decode(ByteBuf in) {
        try {
            byte[] bs;
            short len = in.readShort();
            if (len > 0) {
                bs = new byte[len];
                in.readBytes(bs);
                this.setVersion(new String(bs, UTF8));
            }
            if ((len = in.readShort()) > 0) {
                bs = new byte[len];
                in.readBytes(bs);
                this.setApplicationId(new String(bs, UTF8));
            }
            if ((len = in.readShort()) > 0) {
                bs = new byte[len];
                in.readBytes(bs);
                this.setTransactionServiceGroup(new String(bs, UTF8));
            }
            if ((len = in.readShort()) > 0) {
                bs = new byte[len];
                in.readBytes(bs);
                this.setExtraData(new String(bs, UTF8));
            }
        }
        catch (Exception exx) {
            LOGGER.error(exx.getMessage() + this);
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(in.writerIndex() == in.readerIndex() ? "true" : "false" + this);
        }
        return true;
    }
}

