/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.exception;

import io.seata.core.exception.TransactionException;
import io.seata.core.protocol.ResultCode;
import io.seata.core.protocol.transaction.AbstractTransactionRequest;
import io.seata.core.protocol.transaction.AbstractTransactionResponse;

public abstract class AbstractExceptionHandler {
    public void exceptionHandleTemplate(Callback callback, AbstractTransactionRequest request, AbstractTransactionResponse response) {
        try {
            callback.execute(request, response);
            response.setResultCode(ResultCode.Success);
        }
        catch (TransactionException tex) {
            response.setTransactionExceptionCode(tex.getCode());
            response.setResultCode(ResultCode.Failed);
            response.setMsg("TransactionException[" + tex.getMessage() + "]");
        }
        catch (RuntimeException rex) {
            response.setResultCode(ResultCode.Failed);
            response.setMsg("RuntimeException[" + rex.getMessage() + "]");
        }
    }

    public static interface Callback<T extends AbstractTransactionRequest, S extends AbstractTransactionResponse> {
        public void execute(T var1, S var2) throws TransactionException;
    }
}

