/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.rm.datasource.undo.AbstractUndoExecutor;
import io.seata.rm.datasource.undo.SQLUndoLog;
import io.seata.rm.datasource.undo.mysql.MySQLUndoDeleteExecutor;
import io.seata.rm.datasource.undo.mysql.MySQLUndoInsertExecutor;
import io.seata.rm.datasource.undo.mysql.MySQLUndoUpdateExecutor;
import io.seata.rm.datasource.undo.oracle.OracleUndoDeleteExecutor;
import io.seata.rm.datasource.undo.oracle.OracleUndoInsertExecutor;
import io.seata.rm.datasource.undo.oracle.OracleUndoUpdateExecutor;

public class UndoExecutorFactory {
    public static AbstractUndoExecutor getUndoExecutor(String dbType, SQLUndoLog sqlUndoLog) {
        if (!dbType.equalsIgnoreCase("mysql") && !dbType.equalsIgnoreCase("oracle")) {
            throw new NotSupportYetException(dbType);
        }
        if (dbType.equalsIgnoreCase("oracle")) {
            switch (sqlUndoLog.getSqlType()) {
                case INSERT: {
                    return new OracleUndoInsertExecutor(sqlUndoLog);
                }
                case UPDATE: {
                    return new OracleUndoUpdateExecutor(sqlUndoLog);
                }
                case DELETE: {
                    return new OracleUndoDeleteExecutor(sqlUndoLog);
                }
            }
            throw new ShouldNeverHappenException();
        }
        switch (sqlUndoLog.getSqlType()) {
            case INSERT: {
                return new MySQLUndoInsertExecutor(sqlUndoLog);
            }
            case UPDATE: {
                return new MySQLUndoUpdateExecutor(sqlUndoLog);
            }
            case DELETE: {
                return new MySQLUndoDeleteExecutor(sqlUndoLog);
            }
        }
        throw new ShouldNeverHappenException();
    }
}

