/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.sql.struct.ColumnMeta;
import io.seata.rm.datasource.sql.struct.IndexMeta;
import io.seata.rm.datasource.sql.struct.IndexType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TableMeta {
    private String tableName;
    private Map<String, ColumnMeta> allColumns = new LinkedHashMap<String, ColumnMeta>();
    private Map<String, IndexMeta> allIndexes = new LinkedHashMap<String, IndexMeta>();

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ColumnMeta getColumnMeta(String colName) {
        ColumnMeta col = this.allColumns.get(colName);
        if (col == null) {
            col = colName.charAt(0) == '`' ? this.allColumns.get(colName.substring(1, colName.length() - 1)) : this.allColumns.get("`" + colName + "`");
        }
        return col;
    }

    public Map<String, ColumnMeta> getAllColumns() {
        return this.allColumns;
    }

    public Map<String, IndexMeta> getAllIndexes() {
        return this.allIndexes;
    }

    public ColumnMeta getAutoIncreaseColumn() {
        for (Map.Entry<String, ColumnMeta> entry : this.allColumns.entrySet()) {
            ColumnMeta col = entry.getValue();
            if (!"YES".equalsIgnoreCase(col.getIsAutoincrement())) continue;
            return col;
        }
        return null;
    }

    public Map<String, ColumnMeta> getPrimaryKeyMap() {
        HashMap<String, ColumnMeta> pk = new HashMap<String, ColumnMeta>();
        for (Map.Entry<String, IndexMeta> entry : this.allIndexes.entrySet()) {
            IndexMeta index = entry.getValue();
            if (index.getIndextype().value() != IndexType.PRIMARY.value()) continue;
            for (ColumnMeta col : index.getValues()) {
                pk.put(col.getColumnName(), col);
            }
        }
        if (pk.size() > 1) {
            throw new NotSupportYetException("Multi PK");
        }
        return pk;
    }

    public List<String> getPrimaryKeyOnlyName() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, ColumnMeta> entry : this.getPrimaryKeyMap().entrySet()) {
            list.add(entry.getKey());
        }
        return list;
    }

    public String getPkName() {
        return this.getPrimaryKeyOnlyName().get(0);
    }

    public boolean containsPK(List<String> cols) {
        if (cols == null) {
            return false;
        }
        List<String> pk = this.getPrimaryKeyOnlyName();
        if (pk.isEmpty()) {
            return false;
        }
        if (cols.containsAll(pk)) {
            return true;
        }
        return CollectionUtils.toUpperList(cols).containsAll(CollectionUtils.toUpperList(pk));
    }

    public String getCreateTableSQL() {
        StringBuilder sb = new StringBuilder("CREATE TABLE");
        sb.append(String.format(" `%s` ", this.getTableName()));
        sb.append("(");
        boolean flag = true;
        Map<String, ColumnMeta> allColumns = this.getAllColumns();
        for (Map.Entry<String, ColumnMeta> entry : allColumns.entrySet()) {
            if (flag) {
                flag = false;
            } else {
                sb.append(",");
            }
            ColumnMeta col = entry.getValue();
            sb.append(String.format(" `%s` ", col.getColumnName()));
            sb.append(col.getDataTypeName());
            if (col.getColumnSize() > 0) {
                sb.append(String.format("(%d)", col.getColumnSize()));
            }
            if (col.getColumnDef() != null && col.getColumnDef().length() > 0) {
                sb.append(String.format(" default '%s'", col.getColumnDef()));
            }
            if (col.getIsNullAble() == null || col.getIsNullAble().length() <= 0) continue;
            sb.append(" ");
            sb.append(col.getIsNullAble());
        }
        Map<String, IndexMeta> allIndexes = this.getAllIndexes();
        for (Map.Entry<String, IndexMeta> entry : allIndexes.entrySet()) {
            sb.append(", ");
            IndexMeta index = entry.getValue();
            switch (index.getIndextype()) {
                case FullText: {
                    break;
                }
                case Normal: {
                    sb.append(String.format("KEY `%s`", index.getIndexName()));
                    break;
                }
                case PRIMARY: {
                    sb.append("PRIMARY KEY");
                    break;
                }
                case Unique: {
                    sb.append(String.format("UNIQUE KEY `%s`", index.getIndexName()));
                    break;
                }
            }
            sb.append(" (");
            boolean f = true;
            for (ColumnMeta c : index.getValues()) {
                if (f) {
                    f = false;
                } else {
                    sb.append(",");
                }
                sb.append(String.format("`%s`", c.getColumnName()));
            }
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableMeta)) {
            return false;
        }
        TableMeta tableMeta = (TableMeta)o;
        if (!Objects.equals(tableMeta.tableName, this.tableName)) {
            return false;
        }
        if (!Objects.equals(tableMeta.allColumns, this.allColumns)) {
            return false;
        }
        return Objects.equals(tableMeta.allIndexes, this.allIndexes);
    }

    public int hashCode() {
        int hash = Objects.hashCode(this.tableName);
        hash += Objects.hashCode(this.allColumns);
        return hash += Objects.hashCode(this.allIndexes);
    }
}

