/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.FrameworkException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.StringUtils;
import io.seata.core.model.Resource;
import io.seata.core.model.ResourceManager;
import io.seata.core.protocol.AbstractMessage;
import io.seata.core.protocol.RegisterRMRequest;
import io.seata.core.protocol.RegisterRMResponse;
import io.seata.core.rpc.netty.AbstractRpcRemotingClient;
import io.seata.core.rpc.netty.NettyClientConfig;
import io.seata.core.rpc.netty.NettyPoolKey;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class RmRpcClient
extends AbstractRpcRemotingClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RmRpcClient.class);
    private ResourceManager resourceManager;
    private static volatile RmRpcClient instance;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final long KEEP_ALIVE_TIME = Integer.MAX_VALUE;
    private static final int MAX_QUEUE_SIZE = 20000;
    private String applicationId;
    private String transactionServiceGroup;

    private RmRpcClient(NettyClientConfig nettyClientConfig, EventExecutorGroup eventExecutorGroup, ThreadPoolExecutor messageExecutor) {
        super(nettyClientConfig, eventExecutorGroup, messageExecutor, NettyPoolKey.TransactionRole.RMROLE);
    }

    public static RmRpcClient getInstance(String applicationId, String transactionServiceGroup) {
        RmRpcClient rmRpcClient = RmRpcClient.getInstance();
        rmRpcClient.setApplicationId(applicationId);
        rmRpcClient.setTransactionServiceGroup(transactionServiceGroup);
        return rmRpcClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RmRpcClient getInstance() {
        if (null != instance) return instance;
        Class<RmRpcClient> clazz = RmRpcClient.class;
        synchronized (RmRpcClient.class) {
            if (null != instance) return instance;
            NettyClientConfig nettyClientConfig = new NettyClientConfig();
            ThreadPoolExecutor messageExecutor = new ThreadPoolExecutor(nettyClientConfig.getClientWorkerThreads(), nettyClientConfig.getClientWorkerThreads(), Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(20000), new NamedThreadFactory(nettyClientConfig.getRmDispatchThreadPrefix(), nettyClientConfig.getClientWorkerThreads()), new ThreadPoolExecutor.CallerRunsPolicy());
            instance = new RmRpcClient(nettyClientConfig, null, messageExecutor);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setTransactionServiceGroup(String transactionServiceGroup) {
        this.transactionServiceGroup = transactionServiceGroup;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            super.init();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.initialized.getAndSet(false);
        instance = null;
    }

    @Override
    protected Function<String, NettyPoolKey> getPoolKeyFunction() {
        return serverAddress -> {
            String resourceIds = this.getMergedResourceKeys();
            Object object = ResourceManager.RESOURCE_LOCK;
            synchronized (object) {
                while (StringUtils.isNullOrEmpty(resourceIds)) {
                    try {
                        ResourceManager.RESOURCE_LOCK.wait();
                    }
                    catch (InterruptedException exx) {
                        LOGGER.error("wait resourceIds interrupted error:{}", (Object)exx.getMessage(), (Object)exx);
                    }
                    resourceIds = this.getMergedResourceKeys();
                }
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("RM will register :{}", (Object)resourceIds);
            }
            RegisterRMRequest message = new RegisterRMRequest(this.applicationId, this.transactionServiceGroup);
            message.setResourceIds(resourceIds);
            return new NettyPoolKey(NettyPoolKey.TransactionRole.RMROLE, (String)serverAddress, message);
        };
    }

    @Override
    protected String getTransactionServiceGroup() {
        return this.transactionServiceGroup;
    }

    @Override
    public void onRegisterMsgSuccess(String serverAddress, Channel channel, Object response, AbstractMessage requestMessage) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("register RM success. server version:{},channel:{}", (Object)((RegisterRMResponse)response).getVersion(), (Object)channel);
        }
        this.getClientChannelManager().registerChannel(serverAddress, channel);
        String dbKey = this.getMergedResourceKeys();
        RegisterRMRequest message = (RegisterRMRequest)requestMessage;
        if (message.getResourceIds() != null && !message.getResourceIds().equals(dbKey)) {
            this.sendRegisterMessage(serverAddress, channel, dbKey);
        }
    }

    @Override
    public void onRegisterMsgFail(String serverAddress, Channel channel, Object response, AbstractMessage requestMessage) {
        if (response instanceof RegisterRMResponse && LOGGER.isInfoEnabled()) {
            LOGGER.info("register RM failed. server version:{}", (Object)((RegisterRMResponse)response).getVersion());
        }
        throw new FrameworkException("register RM failed, channel:" + channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResource(String resourceGroupId, String resourceId) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("register to RM resourceId:{}", (Object)resourceId);
        }
        if (this.getClientChannelManager().getChannels().isEmpty()) {
            this.getClientChannelManager().reconnect(this.transactionServiceGroup);
            return;
        }
        ConcurrentMap<String, Channel> concurrentMap = this.getClientChannelManager().getChannels();
        synchronized (concurrentMap) {
            for (Map.Entry entry : this.getClientChannelManager().getChannels().entrySet()) {
                String serverAddress = (String)entry.getKey();
                Channel rmChannel = (Channel)entry.getValue();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("register resource, resourceId:{}", (Object)resourceId);
                }
                this.sendRegisterMessage(serverAddress, rmChannel, resourceId);
            }
        }
    }

    private void sendRegisterMessage(String serverAddress, Channel channel, String dbKey) {
        RegisterRMRequest message = new RegisterRMRequest(this.applicationId, this.transactionServiceGroup);
        message.setResourceIds(dbKey);
        try {
            super.sendAsyncRequestWithoutResponse(channel, message);
        }
        catch (FrameworkException e) {
            if (e.getErrcode() == FrameworkErrorCode.ChannelIsNotWritable && serverAddress != null) {
                this.getClientChannelManager().releaseChannel(channel, serverAddress);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("remove channel:{}", (Object)channel);
                }
            } else {
                LOGGER.error("register RM failed, channel:{}", (Object)channel, (Object)e);
            }
        }
        catch (TimeoutException e) {
            LOGGER.error(e.getMessage());
        }
    }

    private String getMergedResourceKeys() {
        Map<String, Resource> managedResources = this.resourceManager.getManagedResources();
        Set<String> resourceIds = managedResources.keySet();
        if (!resourceIds.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String resourceId : resourceIds) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(resourceId);
            }
            return sb.toString();
        }
        return null;
    }
}

