/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.oio.AbstractOioByteChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.WritableByteChannel;

public abstract class OioByteStreamChannel
extends AbstractOioByteChannel {
    private InputStream is;
    private OutputStream os;
    private WritableByteChannel outChannel;

    protected OioByteStreamChannel(Channel parent, Integer id) {
        super(parent, id);
    }

    protected final void activate(InputStream is, OutputStream os) {
        if (this.is != null) {
            throw new IllegalStateException("input was set already");
        }
        if (this.os != null) {
            throw new IllegalStateException("output was set already");
        }
        if (is == null) {
            throw new NullPointerException("is");
        }
        if (os == null) {
            throw new NullPointerException("os");
        }
        this.is = is;
        this.os = os;
    }

    @Override
    public boolean isActive() {
        return this.is != null && this.os != null;
    }

    @Override
    protected int available() {
        try {
            return this.is.available();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    protected int doReadBytes(ByteBuf buf) throws Exception {
        int length = Math.max(1, Math.min(this.available(), buf.maxWritableBytes()));
        return buf.writeBytes(this.is, length);
    }

    @Override
    protected void doWriteBytes(ByteBuf buf) throws Exception {
        OutputStream os = this.os;
        if (os == null) {
            throw new NotYetConnectedException();
        }
        buf.readBytes(os, buf.readableBytes());
    }

    @Override
    protected void doFlushFileRegion(FileRegion region, ChannelPromise promise) throws Exception {
        OutputStream os = this.os;
        if (os == null) {
            throw new NotYetConnectedException();
        }
        if (this.outChannel == null) {
            this.outChannel = Channels.newChannel(os);
        }
        long written = 0L;
        do {
            long localWritten;
            if ((localWritten = region.transferTo(this.outChannel, written)) == -1L) {
                OioByteStreamChannel.checkEOF(region, written);
                region.release();
                promise.setSuccess();
                return;
            }
            written += localWritten;
            if (!(promise instanceof ChannelProgressivePromise)) continue;
            ChannelProgressivePromise pp = (ChannelProgressivePromise)promise;
            pp.setProgress(written, region.count());
        } while (written < region.count());
        promise.setSuccess();
    }

    @Override
    protected void doClose() throws Exception {
        IOException ex = null;
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            ex = e;
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (IOException e) {
            ex = e;
        }
        this.is = null;
        this.os = null;
        if (ex != null) {
            throw ex;
        }
    }
}

