/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerUtil;
import io.netty.channel.ChannelOperationHandlerAdapter;
import io.netty.channel.ChannelOutboundMessageHandler;
import io.netty.channel.ChannelPromise;
import io.netty.util.Signal;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class ChannelOutboundMessageHandlerAdapter<I>
extends ChannelOperationHandlerAdapter
implements ChannelOutboundMessageHandler<I>,
ChannelHandlerUtil.SingleOutboundMessageHandler<I> {
    protected static final Signal ABORT = ChannelHandlerUtil.ABORT;
    private final TypeParameterMatcher msgMatcher;
    private boolean closeOnFailedFlush = true;

    protected ChannelOutboundMessageHandlerAdapter() {
        this.msgMatcher = TypeParameterMatcher.find((Object)this, ChannelOutboundMessageHandlerAdapter.class, (String)"I");
    }

    protected ChannelOutboundMessageHandlerAdapter(Class<? extends I> outboundMessageType) {
        this.msgMatcher = TypeParameterMatcher.get(outboundMessageType);
    }

    protected final boolean isCloseOnFailedFlush() {
        return this.closeOnFailedFlush;
    }

    protected final void setCloseOnFailedFlush(boolean closeOnFailedFlush) {
        this.closeOnFailedFlush = closeOnFailedFlush;
    }

    @Override
    public MessageBuf<I> newOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return Unpooled.messageBuffer();
    }

    @Override
    public final void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ChannelHandlerUtil.handleFlush(ctx, promise, this.isCloseOnFailedFlush(), this);
    }

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.msgMatcher.match(msg);
    }

    @Override
    public boolean beginFlush(ChannelHandlerContext ctx) throws Exception {
        return true;
    }

    @Override
    public void endFlush(ChannelHandlerContext ctx) throws Exception {
    }
}

