/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.string;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundMessageHandlerAdapter;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public class StringEncoder
extends ChannelOutboundMessageHandlerAdapter<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    public void flush(ChannelHandlerContext ctx, CharSequence msg) throws Exception {
        if (msg.length() == 0) {
            return;
        }
        ByteBuf encoded = Unpooled.copiedBuffer((CharSequence)msg, (Charset)this.charset);
        switch (ctx.nextOutboundBufferType()) {
            case BYTE: {
                ctx.nextOutboundByteBuffer().writeBytes(encoded);
                break;
            }
            case MESSAGE: {
                ctx.nextOutboundMessageBuffer().add((Object)Unpooled.wrappedBuffer((ByteBuf)encoded));
                break;
            }
            default: {
                throw new Error();
            }
        }
    }
}

