/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.OneTimeTask;
import io.netty.util.internal.PlatformDependent;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;

final class MpscLinkedQueue
extends AtomicReference<OneTimeTask>
implements Queue<Runnable> {
    private static final long tailOffset;
    private volatile OneTimeTask tail;

    MpscLinkedQueue() {
        OneTimeTaskAdapter task = new OneTimeTaskAdapter(null);
        this.tail = task;
        this.set(task);
    }

    @Override
    public boolean add(Runnable runnable) {
        if (runnable instanceof OneTimeTask) {
            OneTimeTask node = (OneTimeTask)runnable;
            node.setNext(null);
            this.getAndSet(node).setNext(node);
        } else {
            OneTimeTaskAdapter n = new OneTimeTaskAdapter(runnable);
            ((OneTimeTask)this.getAndSet(n)).setNext(n);
        }
        return true;
    }

    @Override
    public boolean offer(Runnable runnable) {
        return this.add(runnable);
    }

    @Override
    public Runnable remove() {
        Runnable task = this.poll();
        if (task == null) {
            throw new NoSuchElementException();
        }
        return task;
    }

    @Override
    public Runnable poll() {
        OneTimeTask next = this.peekTask();
        if (next == null) {
            return null;
        }
        OneTimeTask ret = next;
        PlatformDependent.putOrderedObject(this, tailOffset, next);
        return MpscLinkedQueue.unwrapIfNeeded(ret);
    }

    @Override
    public Runnable element() {
        OneTimeTask next = this.peekTask();
        if (next == null) {
            throw new NoSuchElementException();
        }
        return MpscLinkedQueue.unwrapIfNeeded(next);
    }

    @Override
    public Runnable peek() {
        OneTimeTask next = this.peekTask();
        if (next == null) {
            return null;
        }
        return MpscLinkedQueue.unwrapIfNeeded(next);
    }

    @Override
    public int size() {
        int count = 0;
        for (OneTimeTask n = this.peekTask(); n != null; n = n.next()) {
            ++count;
        }
        return count;
    }

    private OneTimeTask peekTask() {
        OneTimeTask tail;
        OneTimeTask next;
        while ((next = (tail = (OneTimeTask)PlatformDependent.getObjectVolatile(this, tailOffset)).next()) == null && this.get() != tail) {
        }
        return next;
    }

    @Override
    public boolean isEmpty() {
        return this.peek() == null;
    }

    @Override
    public boolean contains(Object o) {
        for (OneTimeTask n = this.peekTask(); n != null; n = n.next()) {
            if (MpscLinkedQueue.unwrapIfNeeded(n) != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Runnable> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Runnable> c) {
        for (Runnable runnable : c) {
            this.add(runnable);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    private static Runnable unwrapIfNeeded(OneTimeTask task) {
        if (task instanceof OneTimeTaskAdapter) {
            return ((OneTimeTaskAdapter)task).task;
        }
        return task;
    }

    static {
        try {
            tailOffset = PlatformDependent.objectFieldOffset(MpscLinkedQueue.class.getDeclaredField("tail"));
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
    }

    private static final class OneTimeTaskAdapter
    extends OneTimeTask {
        private final Runnable task;

        OneTimeTaskAdapter(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            this.task.run();
        }
    }
}

