/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandler;
import io.netty.channel.ChannelOutboundMessageHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyGoAwayFrame;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyPingFrame;
import io.netty.handler.codec.spdy.SpdyProtocolException;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdySession;
import io.netty.handler.codec.spdy.SpdySessionStatus;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyWindowUpdateFrame;
import io.netty.util.internal.EmptyArrays;
import java.util.concurrent.atomic.AtomicInteger;

public class SpdySessionHandler
extends ChannelDuplexHandler
implements ChannelInboundMessageHandler<Object>,
ChannelOutboundMessageHandler<Object> {
    private static final SpdyProtocolException PROTOCOL_EXCEPTION = new SpdyProtocolException();
    private static final SpdyProtocolException STREAM_CLOSED = new SpdyProtocolException("Stream closed");
    private final SpdySession spdySession = new SpdySession();
    private volatile int lastGoodStreamId;
    private volatile int remoteConcurrentStreams;
    private volatile int localConcurrentStreams;
    private volatile int maxConcurrentStreams;
    private static final int DEFAULT_WINDOW_SIZE = 65536;
    private volatile int initialSendWindowSize = 65536;
    private volatile int initialReceiveWindowSize = 65536;
    private final Object flowControlLock = new Object();
    private final AtomicInteger pings = new AtomicInteger();
    private volatile boolean sentGoAwayFrame;
    private volatile boolean receivedGoAwayFrame;
    private volatile ChannelPromise closeSessionFuture;
    private final boolean server;
    private final boolean flowControl;

    public SpdySessionHandler(int version, boolean server) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        this.server = server;
        this.flowControl = version >= 3;
    }

    @Override
    public MessageBuf<Object> newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return Unpooled.messageBuffer();
    }

    @Override
    public MessageBuf<Object> newOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return Unpooled.messageBuffer();
    }

    @Override
    public void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        Object msg;
        MessageBuf in = ctx.inboundMessageBuffer();
        boolean handled = false;
        while ((msg = in.poll()) != null) {
            if (msg instanceof SpdySynStreamFrame && handled) {
                ctx.fireInboundBufferUpdated();
            }
            this.handleInboundMessage(ctx, msg);
            handled = true;
        }
        ctx.fireInboundBufferUpdated();
    }

    private void handleInboundMessage(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            int streamID = spdyDataFrame.getStreamId();
            if (!this.spdySession.isActiveStream(streamID)) {
                if (streamID <= this.lastGoodStreamId) {
                    this.issueStreamError(ctx, streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                } else if (!this.sentGoAwayFrame) {
                    this.issueStreamError(ctx, streamID, SpdyStreamStatus.INVALID_STREAM);
                }
                return;
            }
            if (this.spdySession.isRemoteSideClosed(streamID)) {
                this.issueStreamError(ctx, streamID, SpdyStreamStatus.STREAM_ALREADY_CLOSED);
                return;
            }
            if (!this.isRemoteInitiatedID(streamID) && !this.spdySession.hasReceivedReply(streamID)) {
                this.issueStreamError(ctx, streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (this.flowControl) {
                int deltaWindowSize = -1 * spdyDataFrame.content().readableBytes();
                int newWindowSize = this.spdySession.updateReceiveWindowSize(streamID, deltaWindowSize);
                if (newWindowSize < this.spdySession.getReceiveWindowSizeLowerBound(streamID)) {
                    this.issueStreamError(ctx, streamID, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                    return;
                }
                if (newWindowSize < 0) {
                    while (spdyDataFrame.content().readableBytes() > this.initialReceiveWindowSize) {
                        DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamID, spdyDataFrame.content().readSlice(this.initialReceiveWindowSize).retain());
                        ctx.nextOutboundMessageBuffer().add(partialDataFrame);
                        ctx.flush();
                    }
                }
                if (newWindowSize <= this.initialReceiveWindowSize / 2 && !spdyDataFrame.isLast()) {
                    deltaWindowSize = this.initialReceiveWindowSize - newWindowSize;
                    this.spdySession.updateReceiveWindowSize(streamID, deltaWindowSize);
                    DefaultSpdyWindowUpdateFrame spdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(streamID, deltaWindowSize);
                    ctx.write(spdyWindowUpdateFrame);
                }
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamID, true);
            }
        } else if (msg instanceof SpdySynStreamFrame) {
            boolean localSideClosed;
            boolean remoteSideClosed;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamID = spdySynStreamFrame.getStreamId();
            if (spdySynStreamFrame.isInvalid() || !this.isRemoteInitiatedID(streamID) || this.spdySession.isActiveStream(streamID)) {
                this.issueStreamError(ctx, streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (streamID <= this.lastGoodStreamId) {
                this.issueSessionError(ctx, SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            byte priority = spdySynStreamFrame.getPriority();
            if (!this.acceptStream(streamID, priority, remoteSideClosed = spdySynStreamFrame.isLast(), localSideClosed = spdySynStreamFrame.isUnidirectional())) {
                this.issueStreamError(ctx, streamID, SpdyStreamStatus.REFUSED_STREAM);
                return;
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamID = spdySynReplyFrame.getStreamId();
            if (spdySynReplyFrame.isInvalid() || this.isRemoteInitiatedID(streamID) || this.spdySession.isRemoteSideClosed(streamID)) {
                this.issueStreamError(ctx, streamID, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (this.spdySession.hasReceivedReply(streamID)) {
                this.issueStreamError(ctx, streamID, SpdyStreamStatus.STREAM_IN_USE);
                return;
            }
            this.spdySession.receivedReply(streamID);
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamID, true);
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            this.removeStream(ctx, spdyRstStreamFrame.getStreamId());
        } else if (msg instanceof SpdySettingsFrame) {
            int newInitialWindowSize;
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            int newConcurrentStreams = spdySettingsFrame.getValue(4);
            if (newConcurrentStreams >= 0) {
                this.updateConcurrentStreams(newConcurrentStreams, true);
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            if (this.flowControl && (newInitialWindowSize = spdySettingsFrame.getValue(7)) >= 0) {
                this.updateInitialSendWindowSize(newInitialWindowSize);
            }
        } else if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            if (this.isRemoteInitiatedID(spdyPingFrame.getId())) {
                ctx.write(spdyPingFrame);
                return;
            }
            if (this.pings.get() == 0) {
                return;
            }
            this.pings.getAndDecrement();
        } else if (msg instanceof SpdyGoAwayFrame) {
            this.receivedGoAwayFrame = true;
        } else if (msg instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
            int streamID = spdyHeadersFrame.getStreamId();
            if (spdyHeadersFrame.isInvalid()) {
                this.issueStreamError(ctx, streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (this.spdySession.isRemoteSideClosed(streamID)) {
                this.issueStreamError(ctx, streamID, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (spdyHeadersFrame.isLast()) {
                this.halfCloseStream(streamID, true);
            }
        } else if (msg instanceof SpdyWindowUpdateFrame && this.flowControl) {
            SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)msg;
            int streamID = spdyWindowUpdateFrame.getStreamId();
            int deltaWindowSize = spdyWindowUpdateFrame.getDeltaWindowSize();
            if (this.spdySession.isLocalSideClosed(streamID)) {
                return;
            }
            if (this.spdySession.getSendWindowSize(streamID) > Integer.MAX_VALUE - deltaWindowSize) {
                this.issueStreamError(ctx, streamID, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                return;
            }
            this.updateSendWindowSize(ctx, streamID, deltaWindowSize);
        }
        ctx.nextInboundMessageBuffer().add(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof SpdyProtocolException) {
            this.issueSessionError(ctx, SpdySessionStatus.PROTOCOL_ERROR);
        }
        super.exceptionCaught(ctx, cause);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.sendGoAwayFrame(ctx, promise);
    }

    @Override
    public void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        Object msg;
        MessageBuf in = ctx.outboundMessageBuffer();
        while ((msg = in.poll()) != null) {
            if (msg instanceof SpdyDataFrame || msg instanceof SpdySynStreamFrame || msg instanceof SpdySynReplyFrame || msg instanceof SpdyRstStreamFrame || msg instanceof SpdySettingsFrame || msg instanceof SpdyPingFrame || msg instanceof SpdyGoAwayFrame || msg instanceof SpdyHeadersFrame || msg instanceof SpdyWindowUpdateFrame) {
                try {
                    this.handleOutboundMessage(ctx, msg);
                    continue;
                }
                catch (SpdyProtocolException e) {
                    if (e != PROTOCOL_EXCEPTION) continue;
                    promise.setFailure(PROTOCOL_EXCEPTION);
                    return;
                }
            }
            ctx.nextOutboundMessageBuffer().add(msg);
        }
        ctx.flush(promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOutboundMessage(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            int streamID = spdyDataFrame.getStreamId();
            if (this.spdySession.isLocalSideClosed(streamID)) {
                throw PROTOCOL_EXCEPTION;
            }
            if (this.flowControl) {
                Object object = this.flowControlLock;
                synchronized (object) {
                    int dataLength = spdyDataFrame.content().readableBytes();
                    int sendWindowSize = this.spdySession.getSendWindowSize(streamID);
                    if (sendWindowSize < dataLength) {
                        if (sendWindowSize > 0) {
                            this.spdySession.updateSendWindowSize(streamID, -1 * sendWindowSize);
                            DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamID, spdyDataFrame.content().readSlice(sendWindowSize).retain());
                            this.spdySession.putPendingWrite(streamID, spdyDataFrame);
                            ctx.nextOutboundMessageBuffer().add(partialDataFrame);
                            return;
                        }
                        this.spdySession.putPendingWrite(streamID, spdyDataFrame);
                        return;
                    }
                    this.spdySession.updateSendWindowSize(streamID, -1 * dataLength);
                }
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamID, false);
            }
        } else if (msg instanceof SpdySynStreamFrame) {
            boolean localSideClosed;
            boolean remoteSideClosed;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamID = spdySynStreamFrame.getStreamId();
            if (this.isRemoteInitiatedID(streamID)) {
                throw PROTOCOL_EXCEPTION;
            }
            byte priority = spdySynStreamFrame.getPriority();
            if (!this.acceptStream(streamID, priority, remoteSideClosed = spdySynStreamFrame.isUnidirectional(), localSideClosed = spdySynStreamFrame.isLast())) {
                throw PROTOCOL_EXCEPTION;
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamID = spdySynReplyFrame.getStreamId();
            if (!this.isRemoteInitiatedID(streamID) || this.spdySession.isLocalSideClosed(streamID)) {
                throw PROTOCOL_EXCEPTION;
            }
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamID, false);
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            this.removeStream(ctx, spdyRstStreamFrame.getStreamId());
        } else if (msg instanceof SpdySettingsFrame) {
            int newInitialWindowSize;
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            int newConcurrentStreams = spdySettingsFrame.getValue(4);
            if (newConcurrentStreams >= 0) {
                this.updateConcurrentStreams(newConcurrentStreams, false);
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            if (this.flowControl && (newInitialWindowSize = spdySettingsFrame.getValue(7)) >= 0) {
                this.updateInitialReceiveWindowSize(newInitialWindowSize);
            }
        } else if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            if (this.isRemoteInitiatedID(spdyPingFrame.getId())) {
                ctx.fireExceptionCaught(new IllegalArgumentException("invalid PING ID: " + spdyPingFrame.getId()));
                return;
            }
            this.pings.getAndIncrement();
        } else {
            if (msg instanceof SpdyGoAwayFrame) {
                throw PROTOCOL_EXCEPTION;
            }
            if (msg instanceof SpdyHeadersFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
                int streamID = spdyHeadersFrame.getStreamId();
                if (this.spdySession.isLocalSideClosed(streamID)) {
                    throw PROTOCOL_EXCEPTION;
                }
                if (spdyHeadersFrame.isLast()) {
                    this.halfCloseStream(streamID, false);
                }
            } else if (msg instanceof SpdyWindowUpdateFrame) {
                throw PROTOCOL_EXCEPTION;
            }
        }
        ctx.nextOutboundMessageBuffer().add(msg);
    }

    private void issueSessionError(ChannelHandlerContext ctx, SpdySessionStatus status) {
        this.sendGoAwayFrame(ctx, status);
        ctx.flush().addListener(ChannelFutureListener.CLOSE);
    }

    private void issueStreamError(ChannelHandlerContext ctx, int streamID, SpdyStreamStatus status) {
        boolean fireMessageReceived = !this.spdySession.isRemoteSideClosed(streamID);
        this.removeStream(ctx, streamID);
        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamID, status);
        ctx.write(spdyRstStreamFrame);
        if (fireMessageReceived) {
            ctx.nextInboundMessageBuffer().add(spdyRstStreamFrame);
            ctx.fireInboundBufferUpdated();
        }
    }

    private boolean isRemoteInitiatedID(int id) {
        boolean serverID = SpdyCodecUtil.isServerId(id);
        return this.server && !serverID || !this.server && serverID;
    }

    private void updateConcurrentStreams(int newConcurrentStreams, boolean remote) {
        if (remote) {
            this.remoteConcurrentStreams = newConcurrentStreams;
        } else {
            this.localConcurrentStreams = newConcurrentStreams;
        }
        if (this.localConcurrentStreams == this.remoteConcurrentStreams) {
            this.maxConcurrentStreams = this.localConcurrentStreams;
            return;
        }
        if (this.localConcurrentStreams == 0) {
            this.maxConcurrentStreams = this.remoteConcurrentStreams;
            return;
        }
        if (this.remoteConcurrentStreams == 0) {
            this.maxConcurrentStreams = this.localConcurrentStreams;
            return;
        }
        this.maxConcurrentStreams = this.localConcurrentStreams > this.remoteConcurrentStreams ? this.remoteConcurrentStreams : this.localConcurrentStreams;
    }

    private synchronized void updateInitialSendWindowSize(int newInitialWindowSize) {
        int deltaWindowSize = newInitialWindowSize - this.initialSendWindowSize;
        this.initialSendWindowSize = newInitialWindowSize;
        for (Integer streamId : this.spdySession.getActiveStreams()) {
            this.spdySession.updateSendWindowSize(streamId, deltaWindowSize);
        }
    }

    private synchronized void updateInitialReceiveWindowSize(int newInitialWindowSize) {
        int deltaWindowSize = newInitialWindowSize - this.initialReceiveWindowSize;
        this.initialReceiveWindowSize = newInitialWindowSize;
        this.spdySession.updateAllReceiveWindowSizes(deltaWindowSize);
    }

    private synchronized boolean acceptStream(int streamID, byte priority, boolean remoteSideClosed, boolean localSideClosed) {
        if (this.receivedGoAwayFrame || this.sentGoAwayFrame) {
            return false;
        }
        int maxConcurrentStreams = this.maxConcurrentStreams;
        if (maxConcurrentStreams != 0 && this.spdySession.numActiveStreams() >= maxConcurrentStreams) {
            return false;
        }
        this.spdySession.acceptStream(streamID, priority, remoteSideClosed, localSideClosed, this.initialSendWindowSize, this.initialReceiveWindowSize);
        if (this.isRemoteInitiatedID(streamID)) {
            this.lastGoodStreamId = streamID;
        }
        return true;
    }

    private void halfCloseStream(int streamID, boolean remote) {
        if (remote) {
            this.spdySession.closeRemoteSide(streamID);
        } else {
            this.spdySession.closeLocalSide(streamID);
        }
        if (this.closeSessionFuture != null && this.spdySession.noActiveStreams()) {
            this.closeSessionFuture.trySuccess();
        }
    }

    private void removeStream(ChannelHandlerContext ctx, int streamID) {
        if (this.spdySession.removeStream(streamID)) {
            ctx.fireExceptionCaught(STREAM_CLOSED);
        }
        if (this.closeSessionFuture != null && this.spdySession.noActiveStreams()) {
            this.closeSessionFuture.trySuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSendWindowSize(ChannelHandlerContext ctx, int streamID, int deltaWindowSize) {
        Object object = this.flowControlLock;
        synchronized (object) {
            SpdyDataFrame spdyDataFrame;
            int newWindowSize = this.spdySession.updateSendWindowSize(streamID, deltaWindowSize);
            while (newWindowSize > 0 && (spdyDataFrame = (SpdyDataFrame)this.spdySession.getPendingWrite(streamID)) != null) {
                int dataFrameSize = spdyDataFrame.content().readableBytes();
                if (newWindowSize >= dataFrameSize) {
                    this.spdySession.removePendingWrite(streamID);
                    newWindowSize = this.spdySession.updateSendWindowSize(streamID, -1 * dataFrameSize);
                    if (spdyDataFrame.isLast()) {
                        this.halfCloseStream(streamID, false);
                    }
                    ctx.nextOutboundMessageBuffer().add(spdyDataFrame);
                    continue;
                }
                this.spdySession.updateSendWindowSize(streamID, -1 * newWindowSize);
                DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamID, spdyDataFrame.content().readSlice(newWindowSize).retain());
                ctx.nextOutboundMessageBuffer().add(partialDataFrame);
                newWindowSize = 0;
            }
        }
    }

    private void sendGoAwayFrame(ChannelHandlerContext ctx, ChannelPromise future) {
        if (!ctx.channel().isActive()) {
            ctx.close(future);
            return;
        }
        this.sendGoAwayFrame(ctx, SpdySessionStatus.OK);
        ChannelFuture f = ctx.flush();
        if (this.spdySession.noActiveStreams()) {
            f.addListener(new ClosingChannelFutureListener(ctx, future));
        } else {
            this.closeSessionFuture = ctx.newPromise();
            this.closeSessionFuture.addListener(new ClosingChannelFutureListener(ctx, future));
        }
    }

    private synchronized void sendGoAwayFrame(ChannelHandlerContext ctx, SpdySessionStatus status) {
        if (!this.sentGoAwayFrame) {
            this.sentGoAwayFrame = true;
            DefaultSpdyGoAwayFrame spdyGoAwayFrame = new DefaultSpdyGoAwayFrame(this.lastGoodStreamId, status);
            ctx.nextOutboundMessageBuffer().add(spdyGoAwayFrame);
        }
    }

    static {
        PROTOCOL_EXCEPTION.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        STREAM_CLOSED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelPromise promise;

        ClosingChannelFutureListener(ChannelHandlerContext ctx, ChannelPromise promise) {
            this.ctx = ctx;
            this.promise = promise;
        }

        @Override
        public void operationComplete(ChannelFuture sentGoAwayFuture) throws Exception {
            this.ctx.close(this.promise);
        }
    }
}

