/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import java.util.LinkedList;
import java.util.Queue;

public class SpdyHttpResponseStreamIdHandler
extends MessageToMessageCodec<Object, Object, HttpMessage, HttpMessage> {
    private static final Integer NO_ID = -1;
    private final Queue<Integer> ids = new LinkedList<Integer>();

    public SpdyHttpResponseStreamIdHandler() {
        super(new Class[]{HttpMessage.class, SpdyRstStreamFrame.class}, new Class[]{HttpMessage.class});
    }

    @Override
    public HttpMessage encode(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
        Integer id = this.ids.poll();
        if (id != null && id.intValue() != NO_ID.intValue() && !msg.containsHeader("X-SPDY-Stream-ID")) {
            SpdyHttpHeaders.setStreamId(msg, id);
        }
        return msg;
    }

    @Override
    public Object decode(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpMessage) {
            boolean contains = ((HttpMessage)msg).containsHeader("X-SPDY-Stream-ID");
            if (!contains) {
                this.ids.add(NO_ID);
            } else {
                this.ids.add(SpdyHttpHeaders.getStreamId((HttpMessage)msg));
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            this.ids.remove(((SpdyRstStreamFrame)msg).getStreamId());
        }
        return msg;
    }
}

