/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyHeaderBlockCompressor;
import java.util.zip.Deflater;

class SpdyHeaderBlockZlibCompressor
extends SpdyHeaderBlockCompressor {
    private final byte[] out = new byte[8192];
    private final Deflater compressor;

    public SpdyHeaderBlockZlibCompressor(int version, int compressionLevel) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        this.compressor = new Deflater(compressionLevel);
        if (version < 3) {
            this.compressor.setDictionary(SpdyCodecUtil.SPDY2_DICT);
        } else {
            this.compressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
        }
    }

    @Override
    public void setInput(ByteBuf decompressed) {
        byte[] in = new byte[decompressed.readableBytes()];
        decompressed.readBytes(in);
        this.compressor.setInput(in);
    }

    @Override
    public void encode(ByteBuf compressed) {
        while (!this.compressor.needsInput()) {
            int numBytes = this.compressor.deflate(this.out, 0, this.out.length, 2);
            compressed.writeBytes(this.out, 0, numBytes);
        }
    }

    @Override
    public void end() {
        this.compressor.end();
    }
}

