/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;

public class TextWebSocketFrame
extends WebSocketFrame {
    public TextWebSocketFrame() {
        this.setBinaryData(Unpooled.EMPTY_BUFFER);
    }

    public TextWebSocketFrame(String text) {
        if (text == null || text.isEmpty()) {
            this.setBinaryData(Unpooled.EMPTY_BUFFER);
        } else {
            this.setBinaryData(Unpooled.copiedBuffer(text, CharsetUtil.UTF_8));
        }
    }

    public TextWebSocketFrame(ByteBuf binaryData) {
        this.setBinaryData(binaryData);
    }

    public TextWebSocketFrame(boolean finalFragment, int rsv, String text) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        if (text == null || text.isEmpty()) {
            this.setBinaryData(Unpooled.EMPTY_BUFFER);
        } else {
            this.setBinaryData(Unpooled.copiedBuffer(text, CharsetUtil.UTF_8));
        }
    }

    public TextWebSocketFrame(boolean finalFragment, int rsv, ByteBuf binaryData) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        this.setBinaryData(binaryData);
    }

    public String getText() {
        if (this.getBinaryData() == null) {
            return null;
        }
        return this.getBinaryData().toString(CharsetUtil.UTF_8);
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        this.setBinaryData(Unpooled.copiedBuffer(text, CharsetUtil.UTF_8));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(text: " + this.getText() + ')';
    }
}

