/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;

public class CloseWebSocketFrame
extends WebSocketFrame {
    public CloseWebSocketFrame() {
        this.setBinaryData(Unpooled.EMPTY_BUFFER);
    }

    public CloseWebSocketFrame(int statusCode, String reasonText) {
        this(true, 0, statusCode, reasonText);
    }

    public CloseWebSocketFrame(boolean finalFragment, int rsv) {
        this(finalFragment, rsv, null);
    }

    public CloseWebSocketFrame(boolean finalFragment, int rsv, int statusCode, String reasonText) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        byte[] reasonBytes = new byte[]{};
        if (reasonText != null) {
            reasonBytes = reasonText.getBytes(CharsetUtil.UTF_8);
        }
        ByteBuf binaryData = Unpooled.buffer(2 + reasonBytes.length);
        binaryData.writeShort(statusCode);
        if (reasonBytes.length > 0) {
            binaryData.writeBytes(reasonBytes);
        }
        binaryData.readerIndex(0);
        this.setBinaryData(binaryData);
    }

    public CloseWebSocketFrame(boolean finalFragment, int rsv, ByteBuf binaryData) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        if (binaryData == null) {
            this.setBinaryData(Unpooled.EMPTY_BUFFER);
        } else {
            this.setBinaryData(binaryData);
        }
    }

    public int getStatusCode() {
        ByteBuf binaryData = this.getBinaryData();
        if (binaryData == null || binaryData.capacity() == 0) {
            return -1;
        }
        binaryData.readerIndex(0);
        short statusCode = binaryData.readShort();
        binaryData.readerIndex(0);
        return statusCode;
    }

    public String getReasonText() {
        ByteBuf binaryData = this.getBinaryData();
        if (binaryData == null || binaryData.capacity() <= 2) {
            return "";
        }
        binaryData.readerIndex(2);
        String reasonText = binaryData.toString(CharsetUtil.UTF_8);
        binaryData.readerIndex(0);
        return reasonText;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

