/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedByteChannel;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.DefaultHttpChunk;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import java.util.ArrayDeque;
import java.util.Queue;

public abstract class HttpContentEncoder
extends MessageToMessageCodec<HttpMessage, HttpMessage, Object, Object> {
    private final Queue<String> acceptEncodingQueue = new ArrayDeque<String>();
    private EmbeddedByteChannel encoder;

    protected HttpContentEncoder() {
        super(new Class[]{HttpMessage.class}, new Class[]{HttpObject.class});
    }

    @Override
    public HttpMessage decode(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
        String acceptedEncoding = msg.getHeader("Accept-Encoding");
        if (acceptedEncoding == null) {
            acceptedEncoding = "identity";
        }
        boolean offered = this.acceptEncodingQueue.offer(acceptedEncoding);
        assert (offered);
        return msg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object encode(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse && ((HttpResponse)msg).getStatus().getCode() == 100) {
            return msg;
        }
        if (msg instanceof HttpMessage) {
            boolean hasContent;
            HttpMessage m = (HttpMessage)msg;
            this.cleanup();
            String acceptEncoding = this.acceptEncodingQueue.poll();
            if (acceptEncoding == null) {
                throw new IllegalStateException("cannot send more responses than requests");
            }
            boolean bl = hasContent = m.getTransferEncoding().isMultiple() || m.getContent().readable();
            if (!hasContent) {
                return m;
            }
            Result result = this.beginEncode(m, acceptEncoding);
            if (result == null) {
                return m;
            }
            this.encoder = result.getContentEncoder();
            m.setHeader("Content-Encoding", result.getTargetContentEncoding());
            if (!m.getTransferEncoding().isSingle()) return msg;
            ByteBuf content = m.getContent();
            ByteBuf newContent = Unpooled.buffer();
            this.encode(content, newContent);
            this.finishEncode(newContent);
            m.setContent(newContent);
            if (!m.containsHeader("Content-Length")) return msg;
            m.setHeader("Content-Length", Integer.toString(newContent.readableBytes()));
            return msg;
        } else {
            if (!(msg instanceof HttpChunk)) return msg;
            HttpChunk c = (HttpChunk)msg;
            ByteBuf content = c.getContent();
            if (this.encoder == null) return msg;
            if (!c.isLast()) {
                ByteBuf newContent = Unpooled.buffer();
                this.encode(content, newContent);
                if (!content.readable()) return null;
                c.setContent(newContent);
                return msg;
            } else {
                ByteBuf lastProduct = Unpooled.buffer();
                this.finishEncode(lastProduct);
                if (!lastProduct.readable()) return msg;
                return new Object[]{new DefaultHttpChunk(lastProduct), c};
            }
        }
    }

    protected abstract Result beginEncode(HttpMessage var1, String var2) throws Exception;

    @Override
    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.afterRemove(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.channelInactive(ctx);
    }

    private void cleanup() {
        if (this.encoder != null) {
            this.finishEncode(Unpooled.buffer());
        }
    }

    private void encode(ByteBuf in, ByteBuf out) {
        this.encoder.writeOutbound(in);
        this.fetchEncoderOutput(out);
    }

    private void finishEncode(ByteBuf out) {
        if (this.encoder.finish()) {
            this.fetchEncoderOutput(out);
        }
        this.encoder = null;
    }

    private void fetchEncoderOutput(ByteBuf out) {
        ByteBuf buf;
        while ((buf = this.encoder.readOutbound()) != null) {
            out.writeBytes(buf);
        }
    }

    public static final class Result {
        private final String targetContentEncoding;
        private final EmbeddedByteChannel contentEncoder;

        public Result(String targetContentEncoding, EmbeddedByteChannel contentEncoder) {
            if (targetContentEncoding == null) {
                throw new NullPointerException("targetContentEncoding");
            }
            if (contentEncoder == null) {
                throw new NullPointerException("contentEncoder");
            }
            this.targetContentEncoding = targetContentEncoding;
            this.contentEncoder = contentEncoder;
        }

        public String getTargetContentEncoding() {
            return this.targetContentEncoding;
        }

        public EmbeddedByteChannel getContentEncoder() {
            return this.contentEncoder;
        }
    }
}

