/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpObject;
import io.netty.handler.codec.http.HttpChunk;

public class DefaultHttpChunk
extends DefaultHttpObject
implements HttpChunk {
    private ByteBuf content;
    private boolean last;

    public DefaultHttpChunk(ByteBuf content) {
        this.setContent(content);
    }

    @Override
    public ByteBuf getContent() {
        return this.content;
    }

    @Override
    public void setContent(ByteBuf content) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        this.last = !content.readable();
        this.content = content;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        boolean last = this.isLast();
        buf.append("(last: ");
        buf.append(last);
        if (!last) {
            buf.append(", size: ");
            buf.append(this.getContent().readableBytes());
        }
        buf.append(", decodeResult: ");
        buf.append(this.getDecoderResult());
        buf.append(')');
        return buf.toString();
    }
}

