/*
 * Decompiled with CFR 0.152.
 */
package io.netty.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.codec.socks.SocksCommonUtils;
import io.netty.codec.socks.SocksInitResponse;
import io.netty.codec.socks.SocksMessage;
import io.netty.codec.socks.SocksResponse;
import io.netty.handler.codec.ReplayingDecoder;

public class SocksInitResponseDecoder
extends ReplayingDecoder<SocksResponse, State> {
    private static final String name = "SOCKS_INIT_RESPONSE_DECODER";
    private SocksMessage.ProtocolVersion version;
    private SocksMessage.AuthScheme authScheme;
    private SocksResponse msg = SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE;

    public static String getName() {
        return name;
    }

    public SocksInitResponseDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    public SocksResponse decode(ChannelHandlerContext ctx, ByteBuf byteBuf) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.ProtocolVersion.fromByte(byteBuf.readByte());
                if (this.version != SocksMessage.ProtocolVersion.SOCKS5) break;
                this.checkpoint(State.READ_PREFFERED_AUTH_TYPE);
            }
            case READ_PREFFERED_AUTH_TYPE: {
                this.authScheme = SocksMessage.AuthScheme.fromByte(byteBuf.readByte());
                this.msg = new SocksInitResponse(this.authScheme);
            }
        }
        ctx.pipeline().remove(this);
        return this.msg;
    }

    public static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_PREFFERED_AUTH_TYPE;

    }
}

