/*
 * Decompiled with CFR 0.152.
 */
package io.netty.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.codec.socks.SocksMessage;
import io.netty.codec.socks.SocksRequest;
import java.util.Collections;
import java.util.List;

public final class SocksInitRequest
extends SocksRequest {
    private final List<SocksMessage.AuthScheme> authSchemes;

    public SocksInitRequest(List<SocksMessage.AuthScheme> authSchemes) {
        super(SocksRequest.SocksRequestType.INIT);
        if (authSchemes == null) {
            throw new NullPointerException("authSchemes");
        }
        this.authSchemes = authSchemes;
    }

    public List<SocksMessage.AuthScheme> getAuthSchemes() {
        return Collections.unmodifiableList(this.authSchemes);
    }

    @Override
    public void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(this.getProtocolVersion().getByteValue());
        byteBuf.writeByte(this.authSchemes.size());
        for (SocksMessage.AuthScheme authScheme : this.authSchemes) {
            byteBuf.writeByte(authScheme.getByteValue());
        }
    }
}

