/*
 * Decompiled with CFR 0.152.
 */
package io.netty.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.codec.socks.SocksMessage;
import io.netty.codec.socks.SocksRequest;
import io.netty.util.CharsetUtil;
import java.net.IDN;
import sun.net.util.IPAddressUtil;

public final class SocksCmdRequest
extends SocksRequest {
    private final SocksMessage.CmdType cmdType;
    private final SocksMessage.AddressType addressType;
    private final String host;
    private final int port;

    public SocksCmdRequest(SocksMessage.CmdType cmdType, SocksMessage.AddressType addressType, String host, int port) {
        super(SocksRequest.SocksRequestType.CMD);
        if (cmdType == null) {
            throw new NullPointerException("cmdType");
        }
        if (addressType == null) {
            throw new NullPointerException("addressType");
        }
        if (host == null) {
            throw new NullPointerException("host");
        }
        switch (addressType) {
            case IPv4: {
                if (IPAddressUtil.isIPv4LiteralAddress(host)) break;
                throw new IllegalArgumentException(host + " is not a valid IPv4 address");
            }
            case DOMAIN: {
                if (IDN.toASCII(host).length() <= 255) break;
                throw new IllegalArgumentException(host + " IDN: " + IDN.toASCII(host) + " exceeds 255 char limit");
            }
            case IPv6: {
                if (IPAddressUtil.isIPv6LiteralAddress(host)) break;
                throw new IllegalArgumentException(host + " is not a valid IPv6 address");
            }
        }
        if (port < 0 && port >= 65535) {
            throw new IllegalArgumentException(port + " is not in bounds 0 < x < 65536");
        }
        this.cmdType = cmdType;
        this.addressType = addressType;
        this.host = IDN.toASCII(host);
        this.port = port;
    }

    public SocksMessage.CmdType getCmdType() {
        return this.cmdType;
    }

    public SocksMessage.AddressType getAddressType() {
        return this.addressType;
    }

    public String getHost() {
        return IDN.toUnicode(this.host);
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(this.getProtocolVersion().getByteValue());
        byteBuf.writeByte(this.cmdType.getByteValue());
        byteBuf.writeByte(0);
        byteBuf.writeByte(this.addressType.getByteValue());
        switch (this.addressType) {
            case IPv4: {
                byteBuf.writeBytes(IPAddressUtil.textToNumericFormatV4(this.host));
                byteBuf.writeShort(this.port);
                break;
            }
            case DOMAIN: {
                byteBuf.writeByte(this.host.length());
                byteBuf.writeBytes(this.host.getBytes(CharsetUtil.US_ASCII));
                byteBuf.writeShort(this.port);
                break;
            }
            case IPv6: {
                byteBuf.writeBytes(IPAddressUtil.textToNumericFormatV6(this.host));
                byteBuf.writeShort(this.port);
            }
        }
    }
}

