/*
 * Decompiled with CFR 0.152.
 */
package io.netty.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.codec.socks.SocksMessage;
import io.netty.codec.socks.SocksResponse;

public final class SocksAuthResponse
extends SocksResponse {
    private static final SocksMessage.SubnegotiationVersion SUBNEGOTIATION_VERSION = SocksMessage.SubnegotiationVersion.AUTH_PASSWORD;
    private final SocksMessage.AuthStatus authStatus;

    public SocksAuthResponse(SocksMessage.AuthStatus authStatus) {
        super(SocksResponse.SocksResponseType.AUTH);
        if (authStatus == null) {
            throw new NullPointerException("authStatus");
        }
        this.authStatus = authStatus;
    }

    public SocksMessage.AuthStatus getAuthStatus() {
        return this.authStatus;
    }

    @Override
    public void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(SUBNEGOTIATION_VERSION.getByteValue());
        byteBuf.writeByte(this.authStatus.getByteValue());
    }
}

