/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.nio.ByteOrder;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.spdy.SpdyDataFrame;
import org.jboss.netty.handler.codec.spdy.SpdyGoAwayFrame;
import org.jboss.netty.handler.codec.spdy.SpdyHeaderBlock;
import org.jboss.netty.handler.codec.spdy.SpdyHeaderBlockCompressor;
import org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import org.jboss.netty.handler.codec.spdy.SpdyNoOpFrame;
import org.jboss.netty.handler.codec.spdy.SpdyPingFrame;
import org.jboss.netty.handler.codec.spdy.SpdyRstStreamFrame;
import org.jboss.netty.handler.codec.spdy.SpdySettingsFrame;
import org.jboss.netty.handler.codec.spdy.SpdySynReplyFrame;
import org.jboss.netty.handler.codec.spdy.SpdySynStreamFrame;
import org.jboss.netty.handler.codec.spdy.SpdyWindowUpdateFrame;

public class SpdyFrameEncoder
implements ChannelDownstreamHandler {
    private final int version;
    private volatile boolean finished;
    private final SpdyHeaderBlockCompressor headerBlockCompressor;

    @Deprecated
    public SpdyFrameEncoder() {
        this(2, 6, 15, 8);
    }

    public SpdyFrameEncoder(int version) {
        this(version, 6, 15, 8);
    }

    @Deprecated
    public SpdyFrameEncoder(int compressionLevel, int windowBits, int memLevel) {
        this(2, compressionLevel, windowBits, memLevel);
    }

    public SpdyFrameEncoder(int version, int compressionLevel, int windowBits, int memLevel) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unknown version: " + version);
        }
        this.version = version;
        this.headerBlockCompressor = SpdyHeaderBlockCompressor.newInstance(version, compressionLevel, windowBits, memLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        ChannelEvent e;
        if (evt instanceof ChannelStateEvent) {
            e = (ChannelStateEvent)evt;
            switch (e.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e.getValue()) && e.getValue() != null) break;
                    SpdyHeaderBlockCompressor spdyHeaderBlockCompressor = this.headerBlockCompressor;
                    synchronized (spdyHeaderBlockCompressor) {
                        this.finished = true;
                        this.headerBlockCompressor.end();
                        break;
                    }
                }
            }
        }
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        e = (MessageEvent)evt;
        Object msg = e.getMessage();
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            ChannelBuffer data = spdyDataFrame.getData();
            int flags = spdyDataFrame.isLast() ? 1 : 0;
            ChannelBuffer header = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8);
            header.writeInt(spdyDataFrame.getStreamId() & Integer.MAX_VALUE);
            header.writeByte(flags);
            header.writeMedium(data.readableBytes());
            ChannelBuffer frame = ChannelBuffers.wrappedBuffer(header, data);
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        if (msg instanceof SpdySynStreamFrame) {
            SpdyHeaderBlockCompressor spdyDataFrame = this.headerBlockCompressor;
            synchronized (spdyDataFrame) {
                int flags;
                SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
                ChannelBuffer data = this.compressHeaderBlock(SpdyFrameEncoder.encodeHeaderBlock(this.version, spdySynStreamFrame));
                int n = flags = spdySynStreamFrame.isLast() ? 1 : 0;
                if (spdySynStreamFrame.isUnidirectional()) {
                    flags = (byte)(flags | 2);
                }
                int headerBlockLength = data.readableBytes();
                int length = this.version < 3 ? (headerBlockLength == 0 ? 12 : 10 + headerBlockLength) : 10 + headerBlockLength;
                ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 20);
                frame.writeShort(this.version | 0x8000);
                frame.writeShort(1);
                frame.writeByte(flags);
                frame.writeMedium(length);
                frame.writeInt(spdySynStreamFrame.getStreamId());
                frame.writeInt(spdySynStreamFrame.getAssociatedToStreamId());
                if (this.version < 3) {
                    int priority = spdySynStreamFrame.getPriority();
                    if (priority > 3) {
                        priority = 3;
                    }
                    frame.writeShort((priority & 0xFF) << 14);
                } else {
                    frame.writeShort((spdySynStreamFrame.getPriority() & 0xFF) << 13);
                }
                if (this.version < 3 && data.readableBytes() == 0) {
                    frame.writeShort(0);
                }
                ChannelBuffer buffer = ChannelBuffers.wrappedBuffer(frame, data);
                Channels.write(ctx, e.getFuture(), buffer, e.getRemoteAddress());
            }
            return;
        }
        if (msg instanceof SpdySynReplyFrame) {
            SpdyHeaderBlockCompressor spdyDataFrame = this.headerBlockCompressor;
            synchronized (spdyDataFrame) {
                SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
                ChannelBuffer data = this.compressHeaderBlock(SpdyFrameEncoder.encodeHeaderBlock(this.version, spdySynReplyFrame));
                int flags = spdySynReplyFrame.isLast() ? 1 : 0;
                int headerBlockLength = data.readableBytes();
                int length = this.version < 3 ? (headerBlockLength == 0 ? 8 : 6 + headerBlockLength) : 4 + headerBlockLength;
                ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 16);
                frame.writeShort(this.version | 0x8000);
                frame.writeShort(2);
                frame.writeByte(flags);
                frame.writeMedium(length);
                frame.writeInt(spdySynReplyFrame.getStreamId());
                if (this.version < 3) {
                    if (data.readableBytes() == 0) {
                        frame.writeInt(0);
                    } else {
                        frame.writeShort(0);
                    }
                }
                ChannelBuffer buffer = ChannelBuffers.wrappedBuffer(frame, data);
                Channels.write(ctx, e.getFuture(), buffer, e.getRemoteAddress());
            }
            return;
        }
        if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 16);
            frame.writeShort(this.version | 0x8000);
            frame.writeShort(3);
            frame.writeInt(8);
            frame.writeInt(spdyRstStreamFrame.getStreamId());
            frame.writeInt(spdyRstStreamFrame.getStatus().getCode());
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        if (msg instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            int flags = spdySettingsFrame.clearPreviouslyPersistedSettings() ? 1 : 0;
            Set<Integer> IDs = spdySettingsFrame.getIds();
            int numEntries = IDs.size();
            int length = 4 + numEntries * 8;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
            frame.writeShort(this.version | 0x8000);
            frame.writeShort(4);
            frame.writeByte(flags);
            frame.writeMedium(length);
            frame.writeInt(numEntries);
            for (Integer ID : IDs) {
                int id = ID;
                byte ID_flags = 0;
                if (spdySettingsFrame.isPersistValue(id)) {
                    ID_flags = (byte)(ID_flags | 1);
                }
                if (spdySettingsFrame.isPersisted(id)) {
                    ID_flags = (byte)(ID_flags | 2);
                }
                if (this.version < 3) {
                    frame.writeByte(id & 0xFF);
                    frame.writeByte(id >> 8 & 0xFF);
                    frame.writeByte(id >> 16 & 0xFF);
                    frame.writeByte(ID_flags);
                } else {
                    frame.writeByte(ID_flags);
                    frame.writeMedium(id);
                }
                frame.writeInt(spdySettingsFrame.getValue(id));
            }
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        if (msg instanceof SpdyNoOpFrame) {
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8);
            frame.writeShort(this.version | 0x8000);
            frame.writeShort(5);
            frame.writeInt(0);
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 12);
            frame.writeShort(this.version | 0x8000);
            frame.writeShort(6);
            frame.writeInt(4);
            frame.writeInt(spdyPingFrame.getId());
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        if (msg instanceof SpdyGoAwayFrame) {
            SpdyGoAwayFrame spdyGoAwayFrame = (SpdyGoAwayFrame)msg;
            int length = this.version < 3 ? 4 : 8;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
            frame.writeShort(this.version | 0x8000);
            frame.writeShort(7);
            frame.writeInt(length);
            frame.writeInt(spdyGoAwayFrame.getLastGoodStreamId());
            if (this.version >= 3) {
                frame.writeInt(spdyGoAwayFrame.getStatus().getCode());
            }
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        if (msg instanceof SpdyHeadersFrame) {
            SpdyHeaderBlockCompressor spdyGoAwayFrame = this.headerBlockCompressor;
            synchronized (spdyGoAwayFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
                ChannelBuffer data = this.compressHeaderBlock(SpdyFrameEncoder.encodeHeaderBlock(this.version, spdyHeadersFrame));
                int flags = spdyHeadersFrame.isLast() ? 1 : 0;
                int headerBlockLength = data.readableBytes();
                int length = this.version < 3 ? (headerBlockLength == 0 ? 4 : 6 + headerBlockLength) : 4 + headerBlockLength;
                ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
                frame.writeShort(this.version | 0x8000);
                frame.writeShort(8);
                frame.writeByte(flags);
                frame.writeMedium(length);
                frame.writeInt(spdyHeadersFrame.getStreamId());
                if (this.version < 3 && data.readableBytes() != 0) {
                    frame.writeShort(0);
                }
                ChannelBuffer buffer = ChannelBuffers.wrappedBuffer(frame, data);
                Channels.write(ctx, e.getFuture(), buffer, e.getRemoteAddress());
            }
            return;
        }
        if (msg instanceof SpdyWindowUpdateFrame) {
            SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)msg;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 16);
            frame.writeShort(this.version | 0x8000);
            frame.writeShort(9);
            frame.writeInt(8);
            frame.writeInt(spdyWindowUpdateFrame.getStreamId());
            frame.writeInt(spdyWindowUpdateFrame.getDeltaWindowSize());
            Channels.write(ctx, e.getFuture(), frame, e.getRemoteAddress());
            return;
        }
        ctx.sendDownstream(evt);
    }

    private static void writeLengthField(int version, ChannelBuffer buffer, int length) {
        if (version < 3) {
            buffer.writeShort(length);
        } else {
            buffer.writeInt(length);
        }
    }

    private static void setLengthField(int version, ChannelBuffer buffer, int writerIndex, int length) {
        if (version < 3) {
            buffer.setShort(writerIndex, length);
        } else {
            buffer.setInt(writerIndex, length);
        }
    }

    private static ChannelBuffer encodeHeaderBlock(int version, SpdyHeaderBlock headerFrame) throws Exception {
        Set<String> names = headerFrame.getHeaderNames();
        int numHeaders = names.size();
        if (numHeaders == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        if (numHeaders > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        ChannelBuffer headerBlock = ChannelBuffers.dynamicBuffer(ByteOrder.BIG_ENDIAN, 256);
        SpdyFrameEncoder.writeLengthField(version, headerBlock, numHeaders);
        for (String name : names) {
            byte[] nameBytes = name.getBytes("UTF-8");
            SpdyFrameEncoder.writeLengthField(version, headerBlock, nameBytes.length);
            headerBlock.writeBytes(nameBytes);
            int savedIndex = headerBlock.writerIndex();
            int valueLength = 0;
            SpdyFrameEncoder.writeLengthField(version, headerBlock, valueLength);
            for (String value : headerFrame.getHeaders(name)) {
                byte[] valueBytes = value.getBytes("UTF-8");
                headerBlock.writeBytes(valueBytes);
                headerBlock.writeByte(0);
                valueLength += valueBytes.length + 1;
            }
            if (--valueLength > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + name);
            }
            SpdyFrameEncoder.setLengthField(version, headerBlock, savedIndex, valueLength);
            headerBlock.writerIndex(headerBlock.writerIndex() - 1);
        }
        return headerBlock;
    }

    private ChannelBuffer compressHeaderBlock(ChannelBuffer uncompressed) throws Exception {
        if (uncompressed.readableBytes() == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        ChannelBuffer compressed = ChannelBuffers.dynamicBuffer();
        if (!this.finished) {
            this.headerBlockCompressor.setInput(uncompressed);
            this.headerBlockCompressor.encode(compressed);
        }
        return compressed;
    }
}

